/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.webmvc.util.version;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import org.springframework.lang.Nullable;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;
import spring.turbo.module.webmvc.util.version.VersionResolver;
import spring.turbo.util.Asserts;
import spring.turbo.util.StringUtils;

public class ServletPathVersionResolver
implements VersionResolver {
    private static final PathMatcher MATCHER = new AntPathMatcher();
    private static final String DEFAULT_PATTERN = "/{version:[vV][0-9]+}/**";
    private static final String DEFAULT_VARIABLE = "version";
    private final String antStylePattern;
    private final String variable;

    public ServletPathVersionResolver() {
        this(DEFAULT_PATTERN, DEFAULT_VARIABLE);
    }

    public ServletPathVersionResolver(String string, String string2) {
        Asserts.hasText((String)string);
        Asserts.hasText((String)string2);
        this.antStylePattern = string;
        this.variable = string2;
    }

    @Override
    @Nullable
    public String resolve(HttpServletRequest httpServletRequest) {
        try {
            String string = httpServletRequest.getServletPath();
            Map map = MATCHER.extractUriTemplateVariables(this.antStylePattern, string);
            String string2 = (String)map.get(this.variable);
            return StringUtils.isNotBlank((String)string2) ? string2 : null;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Override
    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

