/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.zookeeper;

import org.apache.curator.framework.CuratorFramework;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import spring.turbo.module.zookeeper.client.LeaderLatchFactory;
import spring.turbo.module.zookeeper.client.ZookeeperClientFactory;
import spring.turbo.module.zookeeper.configuration.ZookeeperProperties;

@AutoConfiguration
@EnableConfigurationProperties(value={ZookeeperProperties.class})
@ConditionalOnProperty(prefix="springturbo.zookeeper", name={"enabled"}, havingValue="true", matchIfMissing=true)
class SpringBootAutoConfiguration {
    SpringBootAutoConfiguration() {
    }

    @Bean
    public ZookeeperClientFactory zookeeperClientFactory(ZookeeperProperties zookeeperProperties) {
        return new ZookeeperClientFactory(zookeeperProperties);
    }

    @Bean
    @ConditionalOnProperty(prefix="springturbo.zookeeper.leader-election", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public LeaderLatchFactory leaderLatchFactory(ZookeeperProperties zookeeperProperties, CuratorFramework curatorFramework) {
        return new LeaderLatchFactory(zookeeperProperties, curatorFramework);
    }
}

