/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.zookeeper.client;

import java.io.Closeable;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.shared.SharedCount;
import org.apache.curator.utils.CloseableUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.lang.Nullable;
import spring.turbo.util.Asserts;

public class ShardCountFactory
implements FactoryBean<SharedCount>,
InitializingBean,
DisposableBean {
    private final SharedCount count;

    public ShardCountFactory(CuratorFramework curatorFramework, String string, int n) {
        Asserts.notNull((Object)curatorFramework);
        Asserts.notNull((Object)string);
        this.count = new SharedCount(curatorFramework, string, n);
    }

    @Nullable
    public SharedCount getObject() {
        return this.count;
    }

    @Nullable
    public Class<?> getObjectType() {
        return SharedCount.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        this.count.start();
    }

    public void destroy() {
        CloseableUtils.closeQuietly((Closeable)this.count);
    }
}

