/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.zookeeper.configuration;

import java.io.Serializable;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.lang.Nullable;
import spring.turbo.util.Asserts;

@ConfigurationProperties(prefix="springturbo.zookeeper")
public class ZookeeperProperties
implements InitializingBean,
Serializable {
    private boolean enabled = true;
    private String connectString;
    private String namespace;
    private BackoffRetryPolicy backoffRetryPolicy = new BackoffRetryPolicy();
    private LeaderElection leaderElection = new LeaderElection();

    public void afterPropertiesSet() {
        Asserts.notNull((Object)this.connectString);
        Asserts.notNull((Object)this.backoffRetryPolicy);
        Asserts.notNull((Object)this.leaderElection);
        if (this.leaderElection.isEnabled()) {
            Asserts.notNull((Object)this.leaderElection.getZkPath());
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getConnectString() {
        return this.connectString;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public BackoffRetryPolicy getBackoffRetryPolicy() {
        return this.backoffRetryPolicy;
    }

    public LeaderElection getLeaderElection() {
        return this.leaderElection;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public void setConnectString(String string) {
        this.connectString = string;
    }

    public void setNamespace(String string) {
        this.namespace = string;
    }

    public void setBackoffRetryPolicy(BackoffRetryPolicy backoffRetryPolicy) {
        this.backoffRetryPolicy = backoffRetryPolicy;
    }

    public void setLeaderElection(LeaderElection leaderElection) {
        this.leaderElection = leaderElection;
    }

    public static class LeaderElection
    implements Serializable {
        private boolean enabled = true;
        private String zkPath = "/leader-election";
        @Nullable
        private String nodeId;

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getZkPath() {
            return this.zkPath;
        }

        @Nullable
        public String getNodeId() {
            return this.nodeId;
        }

        public void setEnabled(boolean bl) {
            this.enabled = bl;
        }

        public void setZkPath(String string) {
            this.zkPath = string;
        }

        public void setNodeId(@Nullable String string) {
            this.nodeId = string;
        }
    }

    public static class BackoffRetryPolicy
    implements Serializable {
        private int baseSleepTime = 1000;
        private int maxRetries = 29;

        public int getBaseSleepTime() {
            return this.baseSleepTime;
        }

        public int getMaxRetries() {
            return this.maxRetries;
        }

        public void setBaseSleepTime(int n) {
            this.baseSleepTime = n;
        }

        public void setMaxRetries(int n) {
            this.maxRetries = n;
        }
    }
}

