/*
 * Decompiled with CFR 0.152.
 */
package com.github.yuanmomo.mybatis.mbg;

import com.github.yuanmomo.mybatis.mbg.util.JavaFilesMergeUtil;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mybatis.generator.api.MyBatisGenerator;
import org.mybatis.generator.api.ShellCallback;
import org.mybatis.generator.config.Configuration;
import org.mybatis.generator.config.xml.ConfigurationParser;
import org.mybatis.generator.exception.InvalidConfigurationException;
import org.mybatis.generator.exception.XMLParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyBatisGeneratorTool {
    private static Logger logger = LoggerFactory.getLogger(MyBatisGeneratorTool.class);

    public static void generate(String generatorConfigPath, List<String> warnings) {
        if (StringUtils.isBlank((CharSequence)generatorConfigPath)) {
            logger.error("GeneratorConfig.xml location null.");
            return;
        }
        logger.info("Current path is " + new File(".").getAbsolutePath());
        File configFile = new File(generatorConfigPath);
        ConfigurationParser cp = new ConfigurationParser(warnings);
        Configuration config = null;
        try {
            config = cp.parseConfiguration(configFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (XMLParserException e) {
            e.printStackTrace();
        }
        boolean overwrite = false;
        boolean isMergeSupported = true;
        JavaFilesMergeUtil callback = new JavaFilesMergeUtil(overwrite, isMergeSupported);
        MyBatisGenerator myBatisGenerator = null;
        try {
            myBatisGenerator = new MyBatisGenerator(config, (ShellCallback)callback, warnings);
        }
        catch (InvalidConfigurationException e) {
            e.printStackTrace();
        }
        try {
            myBatisGenerator.generate(null);
        }
        catch (SQLException e) {
            logger.error("SQLException", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("IOException", (Throwable)e);
        }
        catch (InterruptedException e) {
            logger.error("InterruptedException", (Throwable)e);
        }
    }

    public static void generate(String generatorConfigPath) {
        ArrayList<String> warnings = new ArrayList<String>();
        MyBatisGeneratorTool.generate(generatorConfigPath, warnings);
    }
}

