/*
 * Decompiled with CFR 0.152.
 */
package com.github.yuanmomo.mybatis.mbg.plugin;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mybatis.generator.api.CommentGenerator;
import org.mybatis.generator.api.GeneratedJavaFile;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.dom.java.CompilationUnit;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.Interface;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.internal.util.StringUtility;

public class DAOPlugin
extends PluginAdapter {
    private static final String typeName = "DAO";

    public boolean validate(List<String> warnings) {
        return true;
    }

    public List<GeneratedJavaFile> contextGenerateAdditionalJavaFiles(IntrospectedTable introspectedTable) {
        CommentGenerator commentGenerator = this.context.getCommentGenerator();
        String javaMapperName = introspectedTable.getMyBatis3JavaMapperType();
        String typeNameProp = this.getProperties().getProperty("typeName");
        if (StringUtils.isBlank((CharSequence)typeNameProp)) {
            typeNameProp = typeName;
        }
        javaMapperName = javaMapperName.replaceAll("Mapper$", typeNameProp);
        FullyQualifiedJavaType type = new FullyQualifiedJavaType(javaMapperName);
        Interface interfaze = new Interface(type);
        interfaze.setVisibility(JavaVisibility.PUBLIC);
        commentGenerator.addJavaFileComment((CompilationUnit)interfaze);
        String rootInterface = introspectedTable.getTableConfigurationProperty("rootInterface");
        if (!StringUtility.stringHasValue((String)rootInterface)) {
            rootInterface = this.context.getJavaClientGeneratorConfiguration().getProperty("rootInterface");
        }
        if (StringUtility.stringHasValue((String)rootInterface)) {
            FullyQualifiedJavaType fqjt = new FullyQualifiedJavaType(rootInterface);
            interfaze.addSuperInterface(fqjt);
            interfaze.addImportedType(fqjt);
        }
        GeneratedJavaFile gjf = new GeneratedJavaFile((CompilationUnit)interfaze, this.context.getJavaClientGeneratorConfiguration().getTargetProject(), this.context.getProperty("javaFileEncoding"), this.context.getJavaFormatter());
        ArrayList<GeneratedJavaFile> gifList = new ArrayList<GeneratedJavaFile>();
        gifList.add(gjf);
        return gifList;
    }
}

