/*
 * Decompiled with CFR 0.152.
 */
package zed.deployer;

import com.github.dockerjava.api.DockerClient;
import java.util.Arrays;
import java.util.List;
import zed.deployer.DockerUriStatusResolver;
import zed.deployer.ProcessUriStatusResolver;
import zed.deployer.StatusResolver;
import zed.deployer.UriStatusResolver;
import zed.deployer.manager.DeployablesManager;
import zed.deployer.manager.DeploymentDescriptor;

public class DefaultStatusResolver
implements StatusResolver {
    private final DeployablesManager deployableManager;
    private final List<UriStatusResolver> statusResolvers;

    public DefaultStatusResolver(DeployablesManager deployableManager, DockerClient docker) {
        this.deployableManager = deployableManager;
        this.statusResolvers = Arrays.asList(new ProcessUriStatusResolver(), new DockerUriStatusResolver(docker));
    }

    @Override
    public boolean status(String deploymentId) {
        DeploymentDescriptor descriptor = this.deployableManager.deployment(deploymentId);
        for (UriStatusResolver uriStatusResolver : this.statusResolvers) {
            if (!uriStatusResolver.support(descriptor.uri())) continue;
            return uriStatusResolver.status(descriptor);
        }
        return false;
    }
}

