/*
 * Decompiled with CFR 0.152.
 */
package zed.deployer.executor;

import java.util.List;
import zed.deployer.executor.ProcessExecutor;
import zed.deployer.executor.ProcessExecutorHandler;
import zed.deployer.manager.DeployablesManager;
import zed.deployer.manager.DeploymentDescriptor;

public class DefaultProcessExecutor
implements ProcessExecutor {
    private final DeployablesManager deployableManager;
    private final List<ProcessExecutorHandler> handlers;

    public DefaultProcessExecutor(DeployablesManager deployableManager, List<ProcessExecutorHandler> handlers) {
        this.handlers = handlers;
        this.deployableManager = deployableManager;
    }

    @Override
    public String start(String deploymentId) {
        DeploymentDescriptor descriptor = this.deployableManager.deployment(deploymentId);
        for (ProcessExecutorHandler handler : this.handlers) {
            if (!handler.supports(descriptor.uri())) continue;
            String pid = handler.start(deploymentId);
            this.deployableManager.update(descriptor.pid(pid));
            return pid;
        }
        throw new RuntimeException("No executor handler for URI: " + descriptor.uri());
    }
}

