/*
 * Decompiled with CFR 0.152.
 */
package zed.deployer.manager;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import zed.deployer.manager.DeploymentDescriptor;

public class BasicDeploymentDescriptor
implements DeploymentDescriptor {
    private final String workspace;
    private final String id;
    private final String uri;
    private final String pid;

    public BasicDeploymentDescriptor(String workspace, String id, String uri, String pid) {
        this.workspace = workspace;
        this.id = id;
        this.uri = uri;
        this.pid = pid;
    }

    public BasicDeploymentDescriptor(String workspace, String id, String uri) {
        this(workspace, id, uri, null);
    }

    @Override
    public String workspace() {
        return this.workspace;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String uri() {
        return this.uri;
    }

    @Override
    public String pid() {
        return this.pid;
    }

    @Override
    public BasicDeploymentDescriptor pid(String pid) {
        return new BasicDeploymentDescriptor(this.workspace, this.id, this.uri, pid);
    }

    public String toString() {
        return this.id + " " + this.uri;
    }

    public void save(File output) {
        try {
            Properties properties = new Properties();
            properties.put("workspace", this.workspace);
            properties.put("id", this.id);
            properties.put("uri", this.uri);
            if (this.pid != null) {
                properties.put("pid", this.pid);
            }
            properties.store(new FileOutputStream(output), "some-comment");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

