/*
 * Decompiled with CFR 0.152.
 */
package zed.deployer.manager;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import zed.deployer.handlers.DeployableHandler;
import zed.deployer.manager.BasicDeploymentDescriptor;
import zed.deployer.manager.DeployablesManager;
import zed.deployer.manager.DeploymentDescriptor;
import zed.deployer.manager.ZedHome;

public class FileSystemDeployablesManager
implements DeployablesManager {
    private final File workspace;
    private final ZedHome zedHome;
    private final List<DeployableHandler> deployHandlers;

    public FileSystemDeployablesManager(ZedHome zedHome, File workspace, List<DeployableHandler> deployHandlers) {
        this.zedHome = zedHome;
        this.workspace = workspace;
        this.workspace.mkdirs();
        this.deployHandlers = deployHandlers;
    }

    @Override
    public DeploymentDescriptor deploy(String uri) {
        String id = UUID.randomUUID().toString();
        BasicDeploymentDescriptor deploymentDescriptor = new BasicDeploymentDescriptor(this.workspace.getName(), id, uri);
        for (DeployableHandler deployHandler : this.deployHandlers) {
            if (!deployHandler.supports(uri)) continue;
            deployHandler.deploy(deploymentDescriptor);
            deploymentDescriptor.save(new File(this.workspace, deploymentDescriptor.id() + ".deploy"));
            return deploymentDescriptor;
        }
        throw new RuntimeException("No handler for deployable with URI: " + uri);
    }

    @Override
    public DeploymentDescriptor update(DeploymentDescriptor pid) {
        BasicDeploymentDescriptor basicDescriptor = (BasicDeploymentDescriptor)pid;
        basicDescriptor.save(new File(this.workspace, pid.id() + ".deploy"));
        return basicDescriptor;
    }

    @Override
    public DeploymentDescriptor deployment(String deploymentId) {
        List deploymentDescriptors = this.list().parallelStream().filter(descriptor -> descriptor.id().equals(deploymentId)).collect(Collectors.toList());
        return new BasicDeploymentDescriptor(this.workspace.getName(), deploymentId, ((DeploymentDescriptor)deploymentDescriptors.get(0)).uri(), ((DeploymentDescriptor)deploymentDescriptors.get(0)).pid());
    }

    @Override
    public List<DeploymentDescriptor> list() {
        return Lists.newArrayList((Object[])this.workspace.listFiles((dir, name) -> name.endsWith(".deploy"))).parallelStream().map(file -> {
            try {
                Properties props = new Properties();
                props.load(new FileInputStream((File)file));
                String pid = props.getProperty("pid");
                String uri = props.getProperty("uri");
                return new BasicDeploymentDescriptor(this.workspace.getName(), file.getName().replaceAll(".deploy", ""), uri, pid);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
    }

    @Override
    public void clear() {
        try {
            FileUtils.deleteDirectory((File)this.workspace);
            this.workspace.mkdirs();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ZedHome zedHome() {
        return this.zedHome;
    }

    public File workspace() {
        return this.workspace;
    }
}

