/*
 * Decompiled with CFR 0.152.
 */
package zed.deployer.executor;

import java.io.File;
import java.io.IOException;
import zed.deployer.executor.ProcessExecutorHandler;
import zed.deployer.manager.DeployablesManager;
import zed.deployer.manager.DeploymentDescriptor;
import zed.deployer.manager.ZedHome;
import zed.utils.Reflections;

public class FatJarLocalProcessExecutionHandler
implements ProcessExecutorHandler {
    ZedHome zedHome;
    DeployablesManager deployablesManager;

    public FatJarLocalProcessExecutionHandler(ZedHome zedHome, DeployablesManager deployablesManager) {
        this.zedHome = zedHome;
        this.deployablesManager = deployablesManager;
    }

    @Override
    public boolean supports(String uri) {
        return uri.startsWith("fatjar:mvn:");
    }

    @Override
    public String start(String deploymentId) {
        DeploymentDescriptor deploymentDescriptor = this.deployablesManager.deployment(deploymentId);
        String name = deploymentDescriptor.uri();
        name = name.substring(name.indexOf(47) + 1);
        name = name.replaceFirst("/", "-");
        name = name.replace('/', '.');
        File toRun = new File(new File(this.zedHome.deployDirectory(), deploymentDescriptor.workspace()), name);
        try {
            Process process = Runtime.getRuntime().exec(new String[]{"java", "-Dzed.deployable.id=" + deploymentId, "-jar", toRun.getAbsolutePath()});
            int pid = (Integer)Reflections.readField((Object)process, (String)"pid", Integer.class);
            return String.valueOf(pid);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

