/*
 * Decompiled with CFR 0.152.
 */
package zed.deployer.handlers;

import com.github.dockerjava.api.DockerClient;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import zed.deployer.handlers.DeployableHandler;
import zed.deployer.manager.DeploymentDescriptor;

public class BaseDockerDeployableHandler
implements DeployableHandler {
    private static final String URI_PREFIX = "docker:";
    private final DockerClient docker;

    public BaseDockerDeployableHandler(DockerClient docker) {
        this.docker = docker;
    }

    protected DockerClient docker() {
        return this.docker;
    }

    @Override
    public boolean supports(String uri) {
        return uri.startsWith(URI_PREFIX);
    }

    @Override
    public void deploy(DeploymentDescriptor deploymentDescriptor) {
        String[] dockerUri = deploymentDescriptor.uri().split(":");
        if (dockerUri.length < 2) {
            throw new IllegalArgumentException(String.valueOf(deploymentDescriptor.uri()) + " is not a valid docker deploy URI. Proper URI format is docker:imagerepoprefix/image[:tag] .");
        }
        InputStream inputStream = null;
        inputStream = dockerUri.length == 3 ? (InputStream)this.docker.pullImageCmd(dockerUri[1]).withTag(dockerUri[2]).exec() : (InputStream)this.docker.pullImageCmd(dockerUri[1]).exec();
        this.asString(inputStream);
    }

    protected String asString(InputStream inputStream) {
        try {
            return IOUtils.toString((InputStream)inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

