/*
 * Decompiled with CFR 0.152.
 */
package zed.mavenrepo;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.jcabi.aether.Aether;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.resolution.DependencyResolutionException;
import org.sonatype.aether.util.artifact.DefaultArtifact;
import zed.mavenrepo.ConfigurableMavenArtifactResolver;
import zed.mavenrepo.MavenDependencyResolutionException;
import zed.mavenrepo.Repository;

public class JcabiMavenArtifactResolver
extends ConfigurableMavenArtifactResolver {
    private final Aether aether = this.initializeAether();

    public JcabiMavenArtifactResolver(List<Repository> repositories) {
        super(repositories);
    }

    public JcabiMavenArtifactResolver() {
    }

    private Aether initializeAether() {
        return new Aether((Collection)Lists.transform((List)this.repositories, (Function)new Function<Repository, RemoteRepository>(){

            public RemoteRepository apply(Repository repository) {
                return new RemoteRepository(repository.id(), "default", repository.url());
            }
        }), new File(String.valueOf(System.getProperty("user.home")) + "/.m2/repository"));
    }

    @Override
    public InputStream artifactStream(final String groupId, final String artifactId, final String version, String extension) {
        try {
            List artifactWithDependencies = this.aether.resolve((Artifact)new DefaultArtifact(groupId, artifactId, "", extension, version), "runtime");
            ArrayList mainArtifacts = Lists.newArrayList((Iterable)Iterables.filter((Iterable)artifactWithDependencies, (Predicate)new Predicate<Artifact>(){

                public boolean apply(Artifact input) {
                    return input.getArtifactId().equals(artifactId) && input.getGroupId().equals(groupId) && input.getVersion().equals(version);
                }
            }));
            if (mainArtifacts.size() > 1) {
                throw new RuntimeException("More than single main artifacts found: " + mainArtifacts);
            }
            return new FileInputStream(((Artifact)mainArtifacts.get(0)).getFile());
        }
        catch (DependencyResolutionException e) {
            throw new MavenDependencyResolutionException(e);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

