/*
 * Decompiled with CFR 0.152.
 */
package zed.service.attachment.sdk;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.client.RestOperations;
import zed.service.attachment.sdk.Attachment;
import zed.service.attachment.sdk.AttachmentService;
import zed.service.document.sdk.DocumentService;
import zed.service.document.sdk.Pojos;
import zed.service.document.sdk.QueryBuilder;
import zed.service.document.sdk.RestDocumentService;
import zed.service.sdk.base.Discoveries;
import zed.service.sdk.base.HealthCheck;
import zed.service.sdk.base.RestTemplates;
import zed.utils.Reflections;

public class RestAttachmentService<T extends Attachment>
implements AttachmentService<T> {
    private static final Logger LOG = LoggerFactory.getLogger(RestAttachmentService.class);
    private static final int DEFAULT_ATTACHMENT_SERVICE_PORT = 15003;
    private final String baseUrl;
    private final RestOperations restClient;
    private final DocumentService<T> documentService;

    public RestAttachmentService(String baseUrl, RestOperations restClient) {
        this.baseUrl = baseUrl;
        this.restClient = restClient;
        this.documentService = new RestDocumentService(baseUrl, restClient);
    }

    public RestAttachmentService(String baseUrl) {
        this(baseUrl, (RestOperations)RestTemplates.defaultRestTemplate());
        LOG.debug("Service will use default RestTemplate instance.");
    }

    public RestAttachmentService(int restApiPort) {
        this("http://localhost:" + restApiPort);
        LOG.debug("Service will connect to the localhost and REST API port {}.", (Object)restApiPort);
    }

    public static <V extends Attachment> RestAttachmentService<V> discover() {
        String serviceUrl = Discoveries.discoverServiceUrl((String)"attachment", (int)15003, (HealthCheck)new HealthCheck(){

            public void check(String serviceUrl) {
                new RestAttachmentService(serviceUrl).count(Attachment.class);
            }
        });
        return new RestAttachmentService(serviceUrl);
    }

    @Override
    public T upload(T attachment) {
        String id = (String)this.restClient.postForObject(String.valueOf(this.baseUrl) + "/api/attachment/upload/" + Pojos.pojoClassToCollection(attachment.getClass()), attachment, String.class, new Object[0]);
        Reflections.writeField(attachment, (String)"id", (Object)id);
        return attachment;
    }

    @Override
    public byte[] download(String id) {
        try {
            return IOUtils.toByteArray((InputStream)new URL(String.valueOf(this.baseUrl) + "/api/attachment/download/" + id).openStream());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public T save(T document) {
        return (T)((Attachment)this.documentService.save(document));
    }

    @Override
    public T findOne(Class<T> documentClass, String id) {
        return (T)((Attachment)this.documentService.findOne(documentClass, id));
    }

    @Override
    public List<T> findMany(Class<T> documentClass, String ... ids) {
        return this.documentService.findMany(documentClass, ids);
    }

    @Override
    public long count(Class<?> documentClass) {
        return this.documentService.count(documentClass);
    }

    @Override
    public List<T> findByQuery(Class<T> documentClass, QueryBuilder queryBuilder) {
        return this.documentService.findByQuery(documentClass, queryBuilder);
    }

    @Override
    public long countByQuery(Class<T> documentClass, QueryBuilder queryBuilder) {
        return this.documentService.countByQuery(documentClass, queryBuilder);
    }

    @Override
    public void remove(Class<T> documentClass, String id) {
        this.documentService.remove(documentClass, id);
    }
}

