/*
 * Decompiled with CFR 0.152.
 */
package zed.service.jsoncrud.sdk;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.client.RestTemplate;
import zed.service.jsoncrud.sdk.JsonCrudService;
import zed.service.jsoncrud.sdk.Pojos;
import zed.service.jsoncrud.sdk.QueryBuilder;

public class RestJsonCrudServiceClient
implements JsonCrudService {
    private final String baseUrl;
    private final RestTemplate restTemplate;

    public RestJsonCrudServiceClient(String baseUrl, RestTemplate restTemplate) {
        this.baseUrl = this.baseUrlWithContextPath(baseUrl);
        this.restTemplate = restTemplate;
    }

    public RestJsonCrudServiceClient(String baseUrl) {
        this(baseUrl, RestJsonCrudServiceClient.createDefaultRestTemplate());
    }

    @Override
    public String save(Object pojo) {
        return (String)this.restTemplate.postForObject(String.format("%s/save/%s", this.baseUrl, Pojos.pojoClassToCollection(pojo.getClass())), pojo, String.class, new Object[0]);
    }

    @Override
    public <T> T findOne(Class<T> pojoClass, String oid) {
        return (T)this.restTemplate.getForObject(String.format("%s/findOne/%s/%s", this.baseUrl, Pojos.pojoClassToCollection(pojoClass), oid), pojoClass, new Object[0]);
    }

    @Override
    public long count(Class<?> pojoClass) {
        return (Long)this.restTemplate.getForObject(String.format("%s/count/%s", this.baseUrl, Pojos.pojoClassToCollection(pojoClass)), Long.class, new Object[0]);
    }

    @Override
    public <C, Q> List<C> findByQuery(Class<C> documentClass, QueryBuilder<Q> query) {
        Class<?> returnType = Array.newInstance(documentClass, 1).getClass();
        String collection = Pojos.pojoClassToCollection(documentClass);
        Object[] documents = (Object[])this.restTemplate.postForObject(String.format("%s/findByQuery/%s", this.baseUrl, collection), query, returnType, new Object[0]);
        return ImmutableList.copyOf((Object[])documents);
    }

    @Override
    public <C, Q> long countByQuery(Class<C> documentClass, QueryBuilder<Q> query) {
        return (Long)this.restTemplate.postForObject(String.format("%s/countByQuery/%s", this.baseUrl, Pojos.pojoClassToCollection(documentClass)), query, Long.class, new Object[0]);
    }

    private String baseUrlWithContextPath(String baseUrl) {
        return baseUrl + "/api/jsonCrud";
    }

    private static RestTemplate createDefaultRestTemplate() {
        RestTemplate restTemplate = new RestTemplate();
        MappingJackson2HttpMessageConverter jacksonConverter = new MappingJackson2HttpMessageConverter();
        jacksonConverter.setObjectMapper(new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setSerializationInclusion(JsonInclude.Include.NON_NULL));
        restTemplate.setMessageConverters(Arrays.asList(jacksonConverter));
        return restTemplate;
    }
}

