/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.distributions;

import be.ac.ulg.montefiore.run.distributions.RandomDistribution;

public class ExponentialDistribution
implements RandomDistribution {
    private double rate;
    private static final long serialVersionUID = 6359607459925864639L;

    public ExponentialDistribution(double d2) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("Argument must be strictly positive");
        }
        this.rate = d2;
    }

    public double rate() {
        return this.rate;
    }

    @Override
    public double generate() {
        return -Math.log(Math.random()) / this.rate;
    }

    @Override
    public double probability(double d2) {
        return this.rate * Math.exp(-d2 * this.rate);
    }
}

