/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.distributions;

import be.ac.ulg.montefiore.run.distributions.RandomDistribution;
import java.util.Random;

public class GaussianDistribution
implements RandomDistribution {
    private double mean;
    private double deviation;
    private double variance;
    private static final Random randomGenerator = new Random();
    private static final long serialVersionUID = 9127329839769283975L;

    public GaussianDistribution() {
        this(0.0, 1.0);
    }

    public GaussianDistribution(double d2, double d3) {
        if (d3 <= 0.0) {
            throw new IllegalArgumentException("Variance must be positive");
        }
        this.mean = d2;
        this.variance = d3;
        this.deviation = Math.sqrt(d3);
    }

    public double mean() {
        return this.mean;
    }

    public double variance() {
        return this.variance;
    }

    @Override
    public double generate() {
        return randomGenerator.nextGaussian() * this.deviation + this.mean;
    }

    @Override
    public double probability(double d2) {
        double d3 = -0.5 * (d2 - this.mean) * (d2 - this.mean) / this.variance;
        return Math.pow(Math.PI * 2 * this.variance, -0.5) * Math.exp(d3);
    }
}

