/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.distributions;

import be.ac.ulg.montefiore.run.distributions.GaussianDistribution;
import be.ac.ulg.montefiore.run.distributions.RandomDistribution;
import java.util.Arrays;
import java.util.Random;

public class GaussianMixtureDistribution
implements RandomDistribution {
    private static final Random random = new Random();
    private GaussianDistribution[] distributions;
    private double[] proportions;
    private static final long serialVersionUID = 2634624658500627331L;

    public GaussianMixtureDistribution(int n) {
        int n2;
        if (n <= 0) {
            throw new IllegalArgumentException("Argument must be strictly positive");
        }
        this.distributions = new GaussianDistribution[n];
        this.proportions = new double[n];
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        for (n2 = 0; n2 < n; ++n2) {
            dArray[n2] = (1.0 + 2.0 * (double)n2) / (2.0 * (double)n);
        }
        Arrays.fill(dArray2, 1.0);
        Arrays.fill(this.proportions, 1.0 / (double)n);
        for (n2 = 0; n2 < this.distributions.length; ++n2) {
            this.distributions[n2] = new GaussianDistribution(dArray[n2], dArray2[n2]);
        }
    }

    public GaussianMixtureDistribution(double[] dArray, double[] dArray2, double[] dArray3) {
        int n;
        if (dArray.length == 0 || dArray.length != dArray2.length || dArray.length != dArray3.length) {
            throw new IllegalArgumentException();
        }
        this.distributions = new GaussianDistribution[dArray.length];
        this.proportions = new double[dArray.length];
        for (int k = 0; k < this.distributions.length; ++k) {
            this.distributions[k] = new GaussianDistribution(dArray[k], dArray2[k]);
        }
        double d2 = 0.0;
        for (n = 0; n < dArray3.length; ++n) {
            d2 += dArray3[n];
        }
        for (n = 0; n < dArray3.length; ++n) {
            this.proportions[n] = dArray3[n] / d2;
        }
    }

    public int nbGaussians() {
        return this.distributions.length;
    }

    public GaussianDistribution[] distributions() {
        return (GaussianDistribution[])this.distributions.clone();
    }

    public double[] proportions() {
        return (double[])this.proportions.clone();
    }

    @Override
    public double generate() {
        double d2 = random.nextDouble();
        double d3 = 0.0;
        for (int k = 0; k < this.proportions.length; ++k) {
            if (!(d2 <= (d3 += this.proportions[k]))) continue;
            return this.distributions[k].generate();
        }
        throw new RuntimeException("Internal error");
    }

    @Override
    public double probability(double d2) {
        double d3 = 0.0;
        for (int k = 0; k < this.distributions.length; ++k) {
            d3 += this.distributions[k].probability(d2) * this.proportions[k];
        }
        return d3;
    }
}

