/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.distributions;

import be.ac.ulg.montefiore.run.distributions.MultiRandomDistribution;
import be.ac.ulg.montefiore.run.distributions.a;
import java.util.Random;

public class MultiGaussianDistribution
implements MultiRandomDistribution {
    private final int dimension;
    private final double[] mean;
    private final double[][] covariance;
    private double[][] covarianceL = null;
    private double[][] covarianceInv = null;
    private double covarianceDet;
    private static final Random randomGenerator = new Random();
    private static final long serialVersionUID = -2438571303843585271L;

    public MultiGaussianDistribution(double[] dArray, double[][] dArray2) {
        if (!a.d(dArray2)) {
            throw new IllegalArgumentException("Covariance must be a square matrix");
        }
        this.dimension = a.b(dArray2);
        if (dArray.length != this.dimension) {
            throw new IllegalArgumentException("mean and covariance dimensions don't match");
        }
        this.mean = a.b(dArray);
        this.covariance = a.a(dArray2);
    }

    public MultiGaussianDistribution(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.dimension = n;
        this.mean = a.c(n);
        this.covariance = a.d(n);
    }

    @Override
    public int dimension() {
        return this.dimension;
    }

    public double[] mean() {
        return (double[])this.mean.clone();
    }

    public double[][] covariance() {
        return a.a(this.covariance);
    }

    private double[][] a() {
        if (this.covarianceL == null) {
            this.covarianceL = a.f(this.covariance);
            this.covarianceDet = a.g(this.covarianceL);
        }
        return this.covarianceL;
    }

    private double[][] b() {
        if (this.covarianceInv == null) {
            this.covarianceInv = a.h(this.a());
        }
        return this.covarianceInv;
    }

    public double covarianceDet() {
        this.a();
        return this.covarianceDet;
    }

    @Override
    public double[] generate() {
        double[] dArray = a.c(this.dimension);
        for (int k = 0; k < this.dimension; ++k) {
            dArray[k] = randomGenerator.nextGaussian();
        }
        return a.a(a.a(this.a(), dArray), this.mean);
    }

    @Override
    public double probability(double[] object) {
        if (((double[])object).length != this.dimension) {
            throw new IllegalArgumentException("Argument array size is not compatible with this distribution");
        }
        double[][] dArray = a.a(a.b(object, this.mean));
        object = dArray;
        double d2 = a.b(a.e(dArray), a.b(this.b(), (double[][])object))[0][0] * -0.5;
        return Math.exp(d2) / (Math.pow(Math.PI * 2, (double)this.dimension / 2.0) * Math.pow(this.covarianceDet(), 0.5));
    }
}

