/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm;

import be.ac.ulg.montefiore.run.jahmm.Centroid;
import be.ac.ulg.montefiore.run.jahmm.ObservationVector;
import java.util.List;

public class CentroidObservationVector
implements Centroid<ObservationVector> {
    private ObservationVector b;

    public CentroidObservationVector(ObservationVector observationVector) {
        this.b = observationVector.clone();
    }

    @Override
    public void reevaluateAdd(ObservationVector object, List<? extends ObservationVector> list) {
        object = ((ObservationVector)object).l;
        for (int k = 0; k < this.b.dimension(); ++k) {
            this.b.l[k] = (this.b.l[k] * (double)list.size() + object[k]) / (double)(list.size() + 1);
        }
    }

    @Override
    public void reevaluateRemove(ObservationVector object, List<? extends ObservationVector> list) {
        object = ((ObservationVector)object).l;
        for (int k = 0; k < this.b.dimension(); ++k) {
            this.b.l[k] = (this.b.l[k] * (double)list.size() - object[k]) / (double)(list.size() - 1);
        }
    }

    @Override
    public double distance(ObservationVector observationVector) {
        observationVector = this.b.minus(observationVector);
        double d2 = 0.0;
        for (int k = 0; k < observationVector.dimension(); ++k) {
            d2 += observationVector.l[k] * observationVector.l[k];
        }
        return Math.sqrt(d2);
    }
}

