/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm;

import be.ac.ulg.montefiore.run.jahmm.Hmm;
import be.ac.ulg.montefiore.run.jahmm.Observation;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;

public class ForwardBackwardCalculator {
    protected double[][] c = null;
    protected double[][] d = null;
    protected double e;

    protected ForwardBackwardCalculator() {
    }

    public <O extends Observation> ForwardBackwardCalculator(List<? extends O> list, Hmm<O> hmm, EnumSet<Computation> enumSet) {
        if (list.isEmpty()) {
            throw new IllegalArgumentException("Invalid empty sequence");
        }
        if (enumSet.contains((Object)Computation.ALPHA)) {
            this.a(hmm, list);
        }
        if (enumSet.contains((Object)Computation.BETA)) {
            this.b(hmm, list);
        }
        this.a(list, hmm, enumSet);
    }

    public <O extends Observation> ForwardBackwardCalculator(List<? extends O> list, Hmm<O> hmm) {
        this(list, hmm, EnumSet.of(Computation.ALPHA));
    }

    protected <O extends Observation> void a(Hmm<? super O> hmm, List<O> list) {
        this.c = new double[list.size()][hmm.nbStates()];
        for (int k = 0; k < hmm.nbStates(); ++k) {
            this.a(hmm, (Observation)list.get(0), k);
        }
        Iterator<O> iterator = list.iterator();
        if (iterator.hasNext()) {
            iterator.next();
        }
        for (int k = 1; k < list.size(); ++k) {
            Observation observation = (Observation)iterator.next();
            for (int i2 = 0; i2 < hmm.nbStates(); ++i2) {
                this.a(hmm, observation, k, i2);
            }
        }
    }

    protected <O extends Observation> void a(Hmm<? super O> hmm, O o, int n) {
        this.c[0][n] = hmm.getPi(n) * hmm.getOpdf(n).probability(o);
    }

    protected <O extends Observation> void a(Hmm<? super O> hmm, O o, int n, int n2) {
        double d2 = 0.0;
        for (int k = 0; k < hmm.nbStates(); ++k) {
            d2 += this.c[n - 1][k] * hmm.getAij(k, n2);
        }
        this.c[n][n2] = d2 * hmm.getOpdf(n2).probability(o);
    }

    protected <O extends Observation> void b(Hmm<? super O> hmm, List<O> list) {
        int n;
        this.d = new double[list.size()][hmm.nbStates()];
        for (n = 0; n < hmm.nbStates(); ++n) {
            this.d[list.size() - 1][n] = 1.0;
        }
        for (n = list.size() - 2; n >= 0; --n) {
            for (int k = 0; k < hmm.nbStates(); ++k) {
                this.b(hmm, (Observation)list.get(n + 1), n, k);
            }
        }
    }

    protected <O extends Observation> void b(Hmm<? super O> hmm, O o, int n, int n2) {
        double d2 = 0.0;
        for (int k = 0; k < hmm.nbStates(); ++k) {
            d2 += this.d[n + 1][k] * hmm.getAij(n2, k) * hmm.getOpdf(k).probability(o);
        }
        this.d[n][n2] = d2;
    }

    public double alphaElement(int n, int n2) {
        if (this.c == null) {
            throw new UnsupportedOperationException("Alpha array has not been computed");
        }
        return this.c[n][n2];
    }

    public double betaElement(int n, int n2) {
        if (this.d == null) {
            throw new UnsupportedOperationException("Beta array has not been computed");
        }
        return this.d[n][n2];
    }

    private <O extends Observation> void a(List<O> list, Hmm<? super O> hmm, EnumSet<Computation> enumSet) {
        this.e = 0.0;
        if (enumSet.contains((Object)Computation.ALPHA)) {
            for (int k = 0; k < hmm.nbStates(); ++k) {
                this.e += this.c[list.size() - 1][k];
            }
        } else {
            for (int k = 0; k < hmm.nbStates(); ++k) {
                this.e += hmm.getPi(k) * hmm.getOpdf(k).probability((Observation)list.get(0)) * this.d[0][k];
            }
        }
    }

    public double probability() {
        return this.e;
    }

    public static enum Computation {
        ALPHA,
        BETA;

    }
}

