/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm;

import be.ac.ulg.montefiore.run.jahmm.ForwardBackwardCalculator;
import be.ac.ulg.montefiore.run.jahmm.Hmm;
import be.ac.ulg.montefiore.run.jahmm.Observation;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;

public class ForwardBackwardScaledCalculator
extends ForwardBackwardCalculator {
    private double[] f;
    private double g;

    public <O extends Observation> ForwardBackwardScaledCalculator(List<? extends O> list, Hmm<O> hmm, EnumSet<ForwardBackwardCalculator.Computation> enumSet) {
        if (list.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.f = new double[list.size()];
        Arrays.fill(this.f, 0.0);
        this.a(hmm, list);
        if (enumSet.contains((Object)ForwardBackwardCalculator.Computation.BETA)) {
            this.b(hmm, list);
        }
        this.a(list, hmm, enumSet);
    }

    public <O extends Observation> ForwardBackwardScaledCalculator(List<? extends O> list, Hmm<O> hmm) {
        this(list, hmm, EnumSet.of(ForwardBackwardCalculator.Computation.ALPHA));
    }

    @Override
    protected <O extends Observation> void a(Hmm<? super O> hmm, List<O> list) {
        this.c = new double[list.size()][hmm.nbStates()];
        for (int k = 0; k < hmm.nbStates(); ++k) {
            this.a(hmm, (Observation)list.get(0), k);
        }
        ForwardBackwardScaledCalculator forwardBackwardScaledCalculator = this;
        forwardBackwardScaledCalculator.a(forwardBackwardScaledCalculator.f, this.c, 0);
        Iterator<O> iterator = list.iterator();
        if (iterator.hasNext()) {
            iterator.next();
        }
        for (int k = 1; k < list.size(); ++k) {
            Observation observation = (Observation)iterator.next();
            for (int i2 = 0; i2 < hmm.nbStates(); ++i2) {
                this.a(hmm, observation, k, i2);
            }
            ForwardBackwardScaledCalculator forwardBackwardScaledCalculator2 = this;
            forwardBackwardScaledCalculator2.a(forwardBackwardScaledCalculator2.f, this.c, k);
        }
    }

    @Override
    protected <O extends Observation> void b(Hmm<? super O> hmm, List<O> list) {
        int n;
        this.d = new double[list.size()][hmm.nbStates()];
        for (n = 0; n < hmm.nbStates(); ++n) {
            this.d[list.size() - 1][n] = 1.0 / this.f[list.size() - 1];
        }
        for (n = list.size() - 2; n >= 0; --n) {
            int n2 = 0;
            while (n2 < hmm.nbStates()) {
                this.b(hmm, (Observation)list.get(n + 1), n, n2);
                double[] dArray = this.d[n];
                int n3 = n2++;
                dArray[n3] = dArray[n3] / this.f[n];
            }
        }
    }

    private void a(double[] dArray, double[][] object, int n) {
        int n2;
        object = object[n];
        double d2 = 0.0;
        for (n2 = 0; n2 < ((double[][])object).length; ++n2) {
            d2 += object[n2];
        }
        dArray[n] = d2;
        n2 = 0;
        while (n2 < ((double[][])object).length) {
            int n3 = n2++;
            object[n3] = object[n3] / d2;
        }
    }

    private <O extends Observation> void a(List<O> list, Hmm<? super O> hmm, EnumSet<ForwardBackwardCalculator.Computation> enumSet) {
        this.g = 0.0;
        for (int k = 0; k < list.size(); ++k) {
            this.g += Math.log(this.f[k]);
        }
        this.e = Math.exp(this.g);
    }

    public double lnProbability() {
        return this.g;
    }
}

