/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm;

import be.ac.ulg.montefiore.run.jahmm.ForwardBackwardCalculator;
import be.ac.ulg.montefiore.run.jahmm.ForwardBackwardScaledCalculator;
import be.ac.ulg.montefiore.run.jahmm.Observation;
import be.ac.ulg.montefiore.run.jahmm.Opdf;
import be.ac.ulg.montefiore.run.jahmm.OpdfFactory;
import be.ac.ulg.montefiore.run.jahmm.ViterbiCalculator;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Hmm<O extends Observation>
implements Serializable,
Cloneable {
    private double[] pi;
    private double[][] a;
    private ArrayList<Opdf<O>> opdfs;
    private static final long serialVersionUID = 2L;

    public Hmm(int n, OpdfFactory<? extends Opdf<O>> opdfFactory) {
        if (n <= 0) {
            throw new IllegalArgumentException("Number of states must be strictly positive");
        }
        this.pi = new double[n];
        int n2 = n;
        this.a = new double[n2][n2];
        this.opdfs = new ArrayList(n);
        for (int k = 0; k < n; ++k) {
            this.pi[k] = 1.0 / (double)n;
            this.opdfs.add(opdfFactory.factor());
            for (int i2 = 0; i2 < n; ++i2) {
                this.a[k][i2] = 1.0 / (double)n;
            }
        }
    }

    public Hmm(double[] dArray, double[][] dArray2, List<? extends Opdf<O>> list) {
        if (dArray2.length == 0 || dArray.length != dArray2.length || list.size() != dArray2.length) {
            throw new IllegalArgumentException("Wrong parameter");
        }
        this.pi = (double[])dArray.clone();
        this.a = new double[dArray2.length][];
        for (int k = 0; k < dArray2.length; ++k) {
            if (dArray2[k].length != dArray2.length) {
                throw new IllegalArgumentException("'A' is not a squarematrix");
            }
            this.a[k] = (double[])dArray2[k].clone();
        }
        this.opdfs = new ArrayList<Opdf<O>>(list);
    }

    protected Hmm(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Number of states must be positive");
        }
        this.pi = new double[n];
        int n2 = n;
        this.a = new double[n2][n2];
        this.opdfs = new ArrayList(n);
        for (int k = 0; k < n; ++k) {
            this.opdfs.add(null);
        }
    }

    public int nbStates() {
        return this.pi.length;
    }

    public double getPi(int n) {
        return this.pi[n];
    }

    public void setPi(int n, double d2) {
        this.pi[n] = d2;
    }

    public Opdf<O> getOpdf(int n) {
        return this.opdfs.get(n);
    }

    public void setOpdf(int n, Opdf<O> opdf) {
        this.opdfs.set(n, opdf);
    }

    public double getAij(int n, int n2) {
        return this.a[n][n2];
    }

    public void setAij(int n, int n2, double d2) {
        this.a[n][n2] = d2;
    }

    public int[] mostLikelyStateSequence(List<? extends O> list) {
        return new ViterbiCalculator(list, this).stateSequence();
    }

    public double probability(List<? extends O> list) {
        return new ForwardBackwardCalculator(list, this).probability();
    }

    public double lnProbability(List<? extends O> list) {
        return new ForwardBackwardScaledCalculator(list, this).lnProbability();
    }

    public double probability(List<? extends O> list, int[] nArray) {
        if (list.size() != nArray.length || list.isEmpty()) {
            throw new IllegalArgumentException();
        }
        double d2 = this.getPi(nArray[0]);
        Iterator<O> iterator = list.iterator();
        for (int k = 0; k < nArray.length - 1; ++k) {
            d2 *= this.getOpdf(nArray[k]).probability((Observation)iterator.next()) * this.getAij(nArray[k], nArray[k + 1]);
        }
        return d2 * this.getOpdf(nArray[nArray.length - 1]).probability((Observation)list.get(nArray.length - 1));
    }

    public String toString(NumberFormat numberFormat) {
        String string = "HMM with " + this.nbStates() + " state(s)\n";
        for (int k = 0; k < this.nbStates(); ++k) {
            string = string + "\nState " + k + "\n";
            string = string + "  Pi: " + this.getPi(k) + "\n";
            string = string + "  Aij:";
            for (int i2 = 0; i2 < this.nbStates(); ++i2) {
                string = string + " " + numberFormat.format(this.getAij(k, i2));
            }
            string = string + "\n";
            string = string + "  Opdf: " + this.getOpdf(k).toString(numberFormat) + "\n";
        }
        return string;
    }

    public String toString() {
        return this.toString(NumberFormat.getInstance());
    }

    public Hmm<O> clone() throws CloneNotSupportedException {
        int n;
        Hmm<O> hmm = new Hmm<O>(this.nbStates());
        new Hmm<O>(this.nbStates()).pi = (double[])this.pi.clone();
        hmm.a = (double[][])this.a.clone();
        for (n = 0; n < this.a.length; ++n) {
            hmm.a[n] = (double[])this.a[n].clone();
        }
        for (n = 0; n < hmm.opdfs.size(); ++n) {
            hmm.opdfs.set(n, this.opdfs.get(n).clone());
        }
        return hmm;
    }
}

