/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm;

import be.ac.ulg.montefiore.run.jahmm.Centroid;
import be.ac.ulg.montefiore.run.jahmm.CentroidFactory;
import be.ac.ulg.montefiore.run.jahmm.CentroidObservationVector;
import be.ac.ulg.montefiore.run.jahmm.Observation;
import java.text.NumberFormat;

public class ObservationVector
extends Observation
implements CentroidFactory<ObservationVector>,
Cloneable {
    final double[] l;

    public ObservationVector(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Dimension must be strictly positive");
        }
        this.l = new double[n];
    }

    public ObservationVector(double[] dArray) {
        this(dArray.length);
        for (int k = 0; k < dArray.length; ++k) {
            this.l[k] = dArray[k];
        }
    }

    public int dimension() {
        return this.l.length;
    }

    public double[] values() {
        return (double[])this.l.clone();
    }

    public double value(int n) {
        return this.l[n];
    }

    @Override
    public Centroid<ObservationVector> factor() {
        return new CentroidObservationVector(this);
    }

    public ObservationVector plus(ObservationVector observationVector) {
        if (this.dimension() != observationVector.dimension()) {
            throw new IllegalArgumentException();
        }
        ObservationVector observationVector2 = new ObservationVector(this.dimension());
        for (int k = 0; k < this.dimension(); ++k) {
            observationVector2.l[k] = this.l[k] + observationVector.l[k];
        }
        return observationVector2;
    }

    public ObservationVector times(double d2) {
        ObservationVector observationVector = this.clone();
        int n = 0;
        while (n < this.dimension()) {
            int n2 = n++;
            observationVector.l[n2] = observationVector.l[n2] * d2;
        }
        return observationVector;
    }

    public ObservationVector minus(ObservationVector observationVector) {
        if (this.dimension() != observationVector.dimension()) {
            throw new IllegalArgumentException();
        }
        ObservationVector observationVector2 = new ObservationVector(this.dimension());
        for (int k = 0; k < this.dimension(); ++k) {
            observationVector2.l[k] = this.l[k] - observationVector.l[k];
        }
        return observationVector2;
    }

    @Override
    public String toString(NumberFormat numberFormat) {
        Object object = "[";
        for (int k = 0; k < this.l.length; ++k) {
            object = (String)object + " " + numberFormat.format(this.l[k]);
        }
        return (String)object + " ]";
    }

    public ObservationVector clone() {
        return new ObservationVector(this.l);
    }
}

