/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm;

import be.ac.ulg.montefiore.run.jahmm.ObservationDiscrete;
import be.ac.ulg.montefiore.run.jahmm.ObservationInteger;
import be.ac.ulg.montefiore.run.jahmm.Opdf;
import be.ac.ulg.montefiore.run.jahmm.OpdfInteger;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;

public class OpdfDiscrete<E extends Enum<E>>
implements Opdf<ObservationDiscrete<E>> {
    protected OpdfInteger distribution;
    protected final List<E> values;
    protected final EnumMap<E, ObservationInteger> toIntegerMap;
    private static final long serialVersionUID = 1L;

    public OpdfDiscrete(Class<E> clazz) {
        this.values = new ArrayList<E>(EnumSet.allOf(clazz));
        if (this.values.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.distribution = new OpdfInteger(this.values.size());
        this.toIntegerMap = this.a(clazz);
    }

    public OpdfDiscrete(Class<E> clazz, double[] dArray) {
        this.values = new ArrayList<E>(EnumSet.allOf(clazz));
        if (dArray.length == 0 || this.values.size() != dArray.length) {
            throw new IllegalArgumentException();
        }
        this.distribution = new OpdfInteger(dArray);
        this.toIntegerMap = this.a(clazz);
    }

    private EnumMap<E, ObservationInteger> a(Class<E> serializable) {
        serializable = new EnumMap(serializable);
        for (Enum enum_ : this.values) {
            ((EnumMap)serializable).put(enum_, new ObservationInteger(enum_.ordinal()));
        }
        return serializable;
    }

    @Override
    public double probability(ObservationDiscrete observationDiscrete) {
        return this.distribution.probability(this.toIntegerMap.get(observationDiscrete.value));
    }

    @Override
    public ObservationDiscrete<E> generate() {
        return new ObservationDiscrete<Enum>((Enum)this.values.get(this.distribution.generate().value));
    }

    public void fit(ObservationDiscrete<E> ... observationDiscreteArray) {
        this.fit((Collection<? extends ObservationDiscrete<E>>)Arrays.asList(observationDiscreteArray));
    }

    @Override
    public void fit(Collection<? extends ObservationDiscrete<E>> object) {
        ArrayList<ObservationInteger> arrayList = new ArrayList<ObservationInteger>();
        object = object.iterator();
        while (object.hasNext()) {
            ObservationDiscrete observationDiscrete = (ObservationDiscrete)object.next();
            arrayList.add(this.toIntegerMap.get(observationDiscrete.value));
        }
        this.distribution.fit((Collection<? extends ObservationInteger>)arrayList);
    }

    public void fit(ObservationDiscrete<E>[] observationDiscreteArray, double[] dArray) {
        this.fit((Collection<? extends ObservationDiscrete<E>>)Arrays.asList(observationDiscreteArray), dArray);
    }

    @Override
    public void fit(Collection<? extends ObservationDiscrete<E>> object, double[] dArray) {
        ArrayList<ObservationInteger> arrayList = new ArrayList<ObservationInteger>();
        object = object.iterator();
        while (object.hasNext()) {
            ObservationDiscrete observationDiscrete = (ObservationDiscrete)object.next();
            arrayList.add(this.toIntegerMap.get(observationDiscrete.value));
        }
        this.distribution.fit((Collection<? extends ObservationInteger>)arrayList, dArray);
    }

    @Override
    public OpdfDiscrete<E> clone() {
        try {
            OpdfDiscrete opdfDiscrete = (OpdfDiscrete)super.clone();
            ((OpdfDiscrete)super.clone()).distribution = this.distribution.clone();
            return opdfDiscrete;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public String toString() {
        return this.toString(NumberFormat.getInstance());
    }

    @Override
    public String toString(NumberFormat numberFormat) {
        Object object = "Discrete distribution --- ";
        int n = 0;
        while (n < this.values.size()) {
            ObservationDiscrete<Enum> observationDiscrete = new ObservationDiscrete<Enum>((Enum)this.values.get(n));
            object = (String)object + observationDiscrete + " " + numberFormat.format(this.probability(observationDiscrete)) + (++n < this.values.size() ? ", " : "");
        }
        return object;
    }
}

