/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm;

import be.ac.ulg.montefiore.run.distributions.GaussianDistribution;
import be.ac.ulg.montefiore.run.jahmm.ObservationReal;
import be.ac.ulg.montefiore.run.jahmm.Opdf;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public class OpdfGaussian
implements Opdf<ObservationReal> {
    private GaussianDistribution distribution;
    private static final long serialVersionUID = 1L;

    public OpdfGaussian() {
        this.distribution = new GaussianDistribution();
    }

    public OpdfGaussian(double d2, double d3) {
        this.distribution = new GaussianDistribution(d2, d3);
    }

    public double mean() {
        return this.distribution.mean();
    }

    public double variance() {
        return this.distribution.variance();
    }

    @Override
    public double probability(ObservationReal observationReal) {
        return this.distribution.probability(observationReal.value);
    }

    @Override
    public ObservationReal generate() {
        return new ObservationReal(this.distribution.generate());
    }

    public void fit(ObservationReal ... observationRealArray) {
        this.fit((Collection<? extends ObservationReal>)Arrays.asList(observationRealArray));
    }

    @Override
    public void fit(Collection<? extends ObservationReal> collection) {
        double[] dArray = new double[collection.size()];
        Arrays.fill(dArray, 1.0 / (double)collection.size());
        this.fit(collection, dArray);
    }

    public void fit(ObservationReal[] observationRealArray, double[] dArray) {
        this.fit((Collection<? extends ObservationReal>)Arrays.asList(observationRealArray), dArray);
    }

    @Override
    public void fit(Collection<? extends ObservationReal> object, double[] dArray) {
        if (object.isEmpty() || object.size() != dArray.length) {
            throw new IllegalArgumentException();
        }
        double d2 = 0.0;
        int n = 0;
        Iterator<? extends ObservationReal> iterator = object.iterator();
        while (iterator.hasNext()) {
            ObservationReal observationReal = iterator.next();
            d2 += observationReal.value * dArray[n++];
        }
        double d3 = 0.0;
        n = 0;
        object = object.iterator();
        while (object.hasNext()) {
            double d4;
            ObservationReal observationReal = (ObservationReal)object.next();
            double d5 = d4 = observationReal.value - d2;
            d3 += d5 * d5 * dArray[n++];
        }
        this.distribution = new GaussianDistribution(d2, d3);
    }

    public OpdfGaussian clone() {
        try {
            return (OpdfGaussian)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
    }

    public String toString() {
        return this.toString(NumberFormat.getInstance());
    }

    @Override
    public String toString(NumberFormat numberFormat) {
        return "Gaussian distribution --- Mean: " + numberFormat.format(this.distribution.mean()) + " Variance " + numberFormat.format(this.distribution.variance());
    }
}

