/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm;

import be.ac.ulg.montefiore.run.distributions.GaussianDistribution;
import be.ac.ulg.montefiore.run.distributions.GaussianMixtureDistribution;
import be.ac.ulg.montefiore.run.jahmm.ObservationReal;
import be.ac.ulg.montefiore.run.jahmm.Opdf;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collection;

public class OpdfGaussianMixture
implements Opdf<ObservationReal> {
    private GaussianMixtureDistribution distribution;
    private static final long serialVersionUID = 1L;

    public OpdfGaussianMixture(int n) {
        this.distribution = new GaussianMixtureDistribution(n);
    }

    public OpdfGaussianMixture(double[] dArray, double[] dArray2, double[] dArray3) {
        this.distribution = new GaussianMixtureDistribution(dArray, dArray2, dArray3);
    }

    @Override
    public double probability(ObservationReal observationReal) {
        return this.distribution.probability(observationReal.value);
    }

    @Override
    public ObservationReal generate() {
        return new ObservationReal(this.distribution.generate());
    }

    public int nbGaussians() {
        return this.distribution.nbGaussians();
    }

    public double[] proportions() {
        return this.distribution.proportions();
    }

    public double[] means() {
        double[] dArray = new double[this.nbGaussians()];
        GaussianDistribution[] gaussianDistributionArray = this.distribution.distributions();
        for (int k = 0; k < gaussianDistributionArray.length; ++k) {
            dArray[k] = gaussianDistributionArray[k].mean();
        }
        return dArray;
    }

    public double[] variances() {
        double[] dArray = new double[this.nbGaussians()];
        GaussianDistribution[] gaussianDistributionArray = this.distribution.distributions();
        for (int k = 0; k < gaussianDistributionArray.length; ++k) {
            dArray[k] = gaussianDistributionArray[k].variance();
        }
        return dArray;
    }

    public void fit(ObservationReal ... observationRealArray) {
        this.fit((Collection<? extends ObservationReal>)Arrays.asList(observationRealArray));
    }

    @Override
    public void fit(Collection<? extends ObservationReal> collection) {
        double[] dArray = new double[collection.size()];
        Arrays.fill(dArray, 1.0 / (double)collection.size());
        this.fit(collection, dArray);
    }

    public void fit(ObservationReal[] observationRealArray, double[] dArray) {
        this.fit((Collection<? extends ObservationReal>)Arrays.asList(observationRealArray), dArray);
    }

    @Override
    public void fit(Collection<? extends ObservationReal> objectArray, double[] dArray) {
        if (objectArray.isEmpty() || objectArray.size() != dArray.length) {
            throw new IllegalArgumentException();
        }
        objectArray = objectArray.toArray(new ObservationReal[objectArray.size()]);
        double[][] dArray2 = this.a((ObservationReal[])objectArray);
        double[] dArray3 = this.a(dArray2, (ObservationReal[])objectArray, dArray);
        double[] dArray4 = this.b(dArray2, (ObservationReal[])objectArray, dArray);
        objectArray = this.c(dArray2, (ObservationReal[])objectArray, dArray);
        this.distribution = new GaussianMixtureDistribution(dArray4, (double[])objectArray, dArray3);
    }

    private double[][] a(ObservationReal[] observationRealArray) {
        double[][] dArray = new double[this.distribution.nbGaussians()][observationRealArray.length];
        for (int k = 0; k < this.distribution.nbGaussians(); ++k) {
            double[] dArray2 = this.distribution.proportions();
            GaussianDistribution[] gaussianDistributionArray = this.distribution.distributions();
            for (int i2 = 0; i2 < observationRealArray.length; ++i2) {
                dArray[k][i2] = dArray2[k] * gaussianDistributionArray[k].probability(observationRealArray[i2].value) / this.probability(observationRealArray[i2]);
            }
        }
        return dArray;
    }

    private double[] a(double[][] dArray, ObservationReal[] objectArray, double[] dArray2) {
        int n;
        objectArray = new double[this.distribution.nbGaussians()];
        double d2 = 0.0;
        Arrays.fill((double[])objectArray, 0.0);
        for (int k = 0; k < this.distribution.nbGaussians(); ++k) {
            for (n = 0; n < dArray2.length; ++n) {
                int n2 = k;
                objectArray[n2] = objectArray[n2] + dArray2[n] * dArray[k][n];
                d2 += dArray2[n] * dArray[k][n];
            }
        }
        double[] dArray3 = new double[this.distribution.nbGaussians()];
        for (n = 0; n < this.distribution.nbGaussians(); ++n) {
            dArray3[n] = (double)(objectArray[n] / d2);
        }
        return dArray3;
    }

    private double[] b(double[][] dArray, ObservationReal[] observationRealArray, double[] dArray2) {
        int n;
        double[] dArray3 = new double[this.distribution.nbGaussians()];
        double[] dArray4 = new double[this.distribution.nbGaussians()];
        Arrays.fill(dArray3, 0.0);
        Arrays.fill(dArray4, 0.0);
        for (int k = 0; k < this.distribution.nbGaussians(); ++k) {
            for (n = 0; n < observationRealArray.length; ++n) {
                int n2 = k;
                dArray3[n2] = dArray3[n2] + dArray2[n] * dArray[k][n] * observationRealArray[n].value;
                int n3 = k;
                dArray4[n3] = dArray4[n3] + dArray2[n] * dArray[k][n];
            }
        }
        double[] dArray5 = new double[this.distribution.nbGaussians()];
        for (n = 0; n < this.distribution.nbGaussians(); ++n) {
            dArray5[n] = dArray3[n] / dArray4[n];
        }
        return dArray5;
    }

    private double[] c(double[][] dArray, ObservationReal[] observationRealArray, double[] dArray2) {
        double[] dArray3 = new double[this.distribution.nbGaussians()];
        double[] dArray4 = new double[this.distribution.nbGaussians()];
        Arrays.fill(dArray3, 0.0);
        Arrays.fill(dArray4, 0.0);
        for (int k = 0; k < this.distribution.nbGaussians(); ++k) {
            GaussianDistribution[] gaussianDistributionArray = this.distribution.distributions();
            for (int i2 = 0; i2 < observationRealArray.length; ++i2) {
                int n = k;
                dArray3[n] = dArray3[n] + dArray2[i2] * dArray[k][i2] * (observationRealArray[i2].value - gaussianDistributionArray[k].mean()) * (observationRealArray[i2].value - gaussianDistributionArray[k].mean());
                int n2 = k;
                dArray4[n2] = dArray4[n2] + dArray2[i2] * dArray[k][i2];
            }
        }
        double[] dArray5 = new double[this.distribution.nbGaussians()];
        for (int k = 0; k < this.distribution.nbGaussians(); ++k) {
            dArray5[k] = dArray3[k] / dArray4[k];
        }
        return dArray5;
    }

    public OpdfGaussianMixture clone() {
        try {
            return (OpdfGaussianMixture)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
    }

    public String toString() {
        return this.toString(NumberFormat.getInstance());
    }

    @Override
    public String toString(NumberFormat numberFormat) {
        Object object = "Gaussian mixture distribution --- ";
        double[] dArray = this.proportions();
        double[] dArray2 = this.means();
        double[] dArray3 = this.variances();
        for (int k = 0; k < this.distribution.nbGaussians(); ++k) {
            object = (String)object + "Gaussian " + (k + 1) + ":\n";
            object = (String)object + "\tMixing Prop = " + numberFormat.format(dArray[k]) + "\n";
            object = (String)object + "\tMean = " + numberFormat.format(dArray2[k]) + "\n";
            object = (String)object + "\tVariance = " + numberFormat.format(dArray3[k]) + "\n";
        }
        return object;
    }
}

