/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm;

import be.ac.ulg.montefiore.run.jahmm.ObservationInteger;
import be.ac.ulg.montefiore.run.jahmm.Opdf;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collection;

public class OpdfInteger
implements Opdf<ObservationInteger> {
    private double[] probabilities;
    private static final long serialVersionUID = 1L;

    public OpdfInteger(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Argument must be strictly positive");
        }
        this.probabilities = new double[n];
        for (int k = 0; k < n; ++k) {
            this.probabilities[k] = 1.0 / (double)n;
        }
    }

    public OpdfInteger(double[] dArray) {
        if (dArray.length == 0) {
            throw new IllegalArgumentException("Invalid empty array");
        }
        this.probabilities = new double[dArray.length];
        for (int k = 0; k < dArray.length; ++k) {
            double d2;
            this.probabilities[k] = dArray[k];
            if (!(d2 < 0.0)) continue;
            throw new IllegalArgumentException();
        }
    }

    public int nbEntries() {
        return this.probabilities.length;
    }

    @Override
    public double probability(ObservationInteger observationInteger) {
        if (observationInteger.value > this.probabilities.length - 1) {
            throw new IllegalArgumentException("Wrong observation value");
        }
        return this.probabilities[observationInteger.value];
    }

    @Override
    public ObservationInteger generate() {
        double d2 = Math.random();
        for (int k = 0; k < this.probabilities.length - 1; ++k) {
            double d3;
            d2 -= this.probabilities[k];
            if (!(d3 < 0.0)) continue;
            return new ObservationInteger(k);
        }
        return new ObservationInteger(this.probabilities.length - 1);
    }

    public void fit(ObservationInteger ... observationIntegerArray) {
        this.fit((Collection<? extends ObservationInteger>)Arrays.asList(observationIntegerArray));
    }

    @Override
    public void fit(Collection<? extends ObservationInteger> collection) {
        if (collection.isEmpty()) {
            throw new IllegalArgumentException("Empty observation set");
        }
        for (int k = 0; k < this.probabilities.length; ++k) {
            this.probabilities[k] = 0.0;
        }
        for (ObservationInteger observationInteger : collection) {
            int n = observationInteger.value;
            this.probabilities[n] = this.probabilities[n] + 1.0;
        }
        int n = 0;
        while (n < this.probabilities.length) {
            int n2 = n++;
            this.probabilities[n2] = this.probabilities[n2] / (double)collection.size();
        }
    }

    public void fit(ObservationInteger[] observationIntegerArray, double[] dArray) {
        this.fit((Collection<? extends ObservationInteger>)Arrays.asList(observationIntegerArray), dArray);
    }

    @Override
    public void fit(Collection<? extends ObservationInteger> object, double[] dArray) {
        if (object.isEmpty() || object.size() != dArray.length) {
            throw new IllegalArgumentException();
        }
        Arrays.fill(this.probabilities, 0.0);
        int n = 0;
        object = object.iterator();
        while (object.hasNext()) {
            ObservationInteger observationInteger = (ObservationInteger)object.next();
            int n2 = observationInteger.value;
            this.probabilities[n2] = this.probabilities[n2] + dArray[n++];
        }
    }

    public OpdfInteger clone() {
        try {
            OpdfInteger opdfInteger = (OpdfInteger)super.clone();
            ((OpdfInteger)super.clone()).probabilities = (double[])this.probabilities.clone();
            return opdfInteger;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
    }

    public String toString() {
        return this.toString(NumberFormat.getInstance());
    }

    @Override
    public String toString(NumberFormat numberFormat) {
        Object object = "Integer distribution --- ";
        int n = 0;
        while (n < this.nbEntries()) {
            ObservationInteger observationInteger = new ObservationInteger(n);
            object = (String)object + numberFormat.format(this.probability(observationInteger)) + (++n < this.nbEntries() ? " " : "");
        }
        return object;
    }
}

