/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm;

import be.ac.ulg.montefiore.run.distributions.MultiGaussianDistribution;
import be.ac.ulg.montefiore.run.jahmm.ObservationVector;
import be.ac.ulg.montefiore.run.jahmm.Opdf;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public class OpdfMultiGaussian
implements Opdf<ObservationVector> {
    private MultiGaussianDistribution distribution;
    private static final long serialVersionUID = 1L;

    public OpdfMultiGaussian(int n) {
        this.distribution = new MultiGaussianDistribution(n);
    }

    public OpdfMultiGaussian(double[] dArray, double[][] dArray2) {
        if (dArray2.length == 0 || dArray.length != dArray2.length || dArray2.length != dArray2[0].length) {
            throw new IllegalArgumentException();
        }
        this.distribution = new MultiGaussianDistribution(dArray, dArray2);
    }

    public double[] mean() {
        return this.distribution.mean();
    }

    public double[][] covariance() {
        return this.distribution.covariance();
    }

    public int dimension() {
        return this.distribution.dimension();
    }

    @Override
    public double probability(ObservationVector observationVector) {
        if (observationVector.dimension() != this.distribution.dimension()) {
            throw new IllegalArgumentException("Vector has a wrong dimension");
        }
        return this.distribution.probability(observationVector.l);
    }

    @Override
    public ObservationVector generate() {
        return new ObservationVector(this.distribution.generate());
    }

    public void fit(ObservationVector ... observationVectorArray) {
        this.fit((Collection<? extends ObservationVector>)Arrays.asList(observationVectorArray));
    }

    @Override
    public void fit(Collection<? extends ObservationVector> collection) {
        if (collection.isEmpty()) {
            throw new IllegalArgumentException("Empty observation set");
        }
        double[] dArray = new double[collection.size()];
        Arrays.fill(dArray, 1.0 / (double)collection.size());
        this.fit(collection, dArray);
    }

    public void fit(ObservationVector[] observationVectorArray, double[] dArray) {
        this.fit((Collection<? extends ObservationVector>)Arrays.asList(observationVectorArray), dArray);
    }

    @Override
    public void fit(Collection<? extends ObservationVector> object, double[] dArray) {
        Object object2;
        Iterator<? extends ObservationVector> iterator;
        int n;
        if (object.isEmpty() || object.size() != dArray.length) {
            throw new IllegalArgumentException();
        }
        double[] dArray2 = new double[this.dimension()];
        for (int k = 0; k < this.dimension(); ++k) {
            n = 0;
            iterator = object.iterator();
            while (iterator.hasNext()) {
                object2 = iterator.next();
                int n2 = k;
                dArray2[n2] = dArray2[n2] + ((ObservationVector)object2).l[k] * dArray[n++];
            }
        }
        double[][] dArray3 = new double[this.dimension()][this.dimension()];
        n = 0;
        iterator = object.iterator();
        while (iterator.hasNext()) {
            int n3;
            object2 = iterator.next();
            object = ((ObservationVector)object2).l;
            object2 = new double[((ObservationVector)object2).l.length];
            for (n3 = 0; n3 < ((Object)object).length; ++n3) {
                object2[n3] = object[n3] - dArray2[n3];
            }
            for (n3 = 0; n3 < this.dimension(); ++n3) {
                for (int k = 0; k < this.dimension(); ++k) {
                    double[] dArray4 = dArray3[n3];
                    int n4 = k;
                    dArray4[n4] = dArray4[n4] + object2[n3] * object2[k] * dArray[n];
                }
            }
            ++n;
        }
        this.distribution = new MultiGaussianDistribution(dArray2, dArray3);
    }

    public OpdfMultiGaussian clone() {
        try {
            return (OpdfMultiGaussian)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
    }

    public String toString() {
        return this.toString(NumberFormat.getInstance());
    }

    @Override
    public String toString(NumberFormat numberFormat) {
        Object object = "Multi-variate Gaussian distribution --- Mean: [ ";
        double[] dArray = this.distribution.mean();
        for (int k = 0; k < dArray.length; ++k) {
            object = (String)object + numberFormat.format(dArray[k]) + " ";
        }
        return (String)object + "]";
    }
}

