/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm;

import be.ac.ulg.montefiore.run.jahmm.Hmm;
import be.ac.ulg.montefiore.run.jahmm.Observation;
import java.util.Iterator;
import java.util.List;

public class ViterbiCalculator {
    private double[][] p;
    private int[][] q;
    private int[] r;
    private double g;

    public <O extends Observation> ViterbiCalculator(List<? extends O> list, Hmm<O> hmm) {
        int n;
        if (list.isEmpty()) {
            throw new IllegalArgumentException("Invalid empty sequence");
        }
        this.p = new double[list.size()][hmm.nbStates()];
        this.q = new int[list.size()][hmm.nbStates()];
        this.r = new int[list.size()];
        for (int k = 0; k < hmm.nbStates(); ++k) {
            this.p[0][k] = -Math.log(hmm.getPi(k)) - Math.log(hmm.getOpdf(k).probability((Observation)list.get(0)));
            this.q[0][k] = 0;
        }
        Iterator<O> iterator = list.iterator();
        if (iterator.hasNext()) {
            iterator.next();
        }
        int n2 = 1;
        while (iterator.hasNext()) {
            Observation observation = (Observation)iterator.next();
            for (int k = 0; k < hmm.nbStates(); ++k) {
                this.c(hmm, observation, n2, k);
            }
            ++n2;
        }
        this.g = Double.MAX_VALUE;
        for (n = 0; n < hmm.nbStates(); ++n) {
            double d2 = this.p[list.size() - 1][n];
            if (!(this.g > d2)) continue;
            this.g = d2;
            this.r[list.size() - 1] = n;
        }
        this.g = -this.g;
        for (n = list.size() - 2; n >= 0; --n) {
            this.r[n] = this.q[n + 1][this.r[n + 1]];
        }
    }

    private <O extends Observation> void c(Hmm<O> hmm, O o, int n, int n2) {
        double d2 = Double.MAX_VALUE;
        int n3 = 0;
        for (int k = 0; k < hmm.nbStates(); ++k) {
            double d3 = this.p[n - 1][k] - Math.log(hmm.getAij(k, n2));
            if (!(d2 > d3)) continue;
            d2 = d3;
            n3 = k;
        }
        this.p[n][n2] = d2 - Math.log(hmm.getOpdf(n2).probability(o));
        this.q[n][n2] = n3;
    }

    public double lnProbability() {
        return this.g;
    }

    public int[] stateSequence() {
        return (int[])this.r.clone();
    }
}

