/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm.apps.sample;

import be.ac.ulg.montefiore.run.jahmm.Hmm;
import be.ac.ulg.montefiore.run.jahmm.Observation;
import be.ac.ulg.montefiore.run.jahmm.ObservationDiscrete;
import be.ac.ulg.montefiore.run.jahmm.OpdfDiscrete;
import be.ac.ulg.montefiore.run.jahmm.OpdfDiscreteFactory;
import be.ac.ulg.montefiore.run.jahmm.draw.GenericHmmDrawerDot;
import be.ac.ulg.montefiore.run.jahmm.learn.BaumWelchLearner;
import be.ac.ulg.montefiore.run.jahmm.toolbox.KullbackLeiblerDistanceCalculator;
import be.ac.ulg.montefiore.run.jahmm.toolbox.MarkovGenerator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SimpleExample {
    public static void main(String[] object) throws IOException {
        object = SimpleExample.l();
        List<List<ObservationDiscrete<Packet>>> list = SimpleExample.a(object);
        BaumWelchLearner baumWelchLearner = new BaumWelchLearner();
        Hmm<ObservationDiscrete<Packet>> hmm = SimpleExample.m();
        KullbackLeiblerDistanceCalculator kullbackLeiblerDistanceCalculator = new KullbackLeiblerDistanceCalculator();
        for (int k = 0; k < 10; ++k) {
            System.out.println("Distance at iteration " + k + ": " + kullbackLeiblerDistanceCalculator.distance(hmm, object));
            hmm = baumWelchLearner.iterate(hmm, list);
        }
        System.out.println("Resulting HMM:\n" + hmm);
        ObservationDiscrete<Packet> observationDiscrete = Packet.OK.observation();
        object = Packet.LOSS.observation();
        list = new ArrayList<List<ObservationDiscrete<Packet>>>();
        list.add((List<ObservationDiscrete<Packet>>)((Object)observationDiscrete));
        list.add((List<ObservationDiscrete<Packet>>)((Object)observationDiscrete));
        list.add((List<ObservationDiscrete<Packet>>)object);
        System.out.println("Sequence probability: " + hmm.probability(list));
        new GenericHmmDrawerDot().write(hmm, "learntHmm.dot");
    }

    static Hmm<ObservationDiscrete<Packet>> l() {
        Hmm<ObservationDiscrete<Packet>> hmm = new Hmm<ObservationDiscrete<Packet>>(2, new OpdfDiscreteFactory<Packet>(Packet.class));
        hmm.setPi(0, 0.95);
        hmm.setPi(1, 0.05);
        hmm.setOpdf(0, new OpdfDiscrete<Packet>(Packet.class, new double[]{0.95, 0.05}));
        hmm.setOpdf(1, new OpdfDiscrete<Packet>(Packet.class, new double[]{0.2, 0.8}));
        hmm.setAij(0, 1, 0.05);
        hmm.setAij(0, 0, 0.95);
        hmm.setAij(1, 0, 0.1);
        hmm.setAij(1, 1, 0.9);
        return hmm;
    }

    static Hmm<ObservationDiscrete<Packet>> m() {
        Hmm<ObservationDiscrete<Packet>> hmm = new Hmm<ObservationDiscrete<Packet>>(2, new OpdfDiscreteFactory<Packet>(Packet.class));
        hmm.setPi(0, 0.5);
        hmm.setPi(1, 0.5);
        hmm.setOpdf(0, new OpdfDiscrete<Packet>(Packet.class, new double[]{0.8, 0.2}));
        hmm.setOpdf(1, new OpdfDiscrete<Packet>(Packet.class, new double[]{0.1, 0.9}));
        hmm.setAij(0, 1, 0.2);
        hmm.setAij(0, 0, 0.8);
        hmm.setAij(1, 0, 0.2);
        hmm.setAij(1, 1, 0.8);
        return hmm;
    }

    static <O extends Observation> List<List<O>> a(Hmm<O> object) {
        object = new MarkovGenerator<O>(object);
        ArrayList<List<O>> arrayList = new ArrayList<List<O>>();
        for (int k = 0; k < 200; ++k) {
            arrayList.add(((MarkovGenerator)object).observationSequence(100));
        }
        return arrayList;
    }

    public static enum Packet {
        OK,
        LOSS;


        public ObservationDiscrete<Packet> observation() {
            return new ObservationDiscrete<Packet>(this);
        }
    }
}

