/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm.io;

import be.ac.ulg.montefiore.run.jahmm.Hmm;
import be.ac.ulg.montefiore.run.jahmm.Observation;
import be.ac.ulg.montefiore.run.jahmm.Opdf;
import be.ac.ulg.montefiore.run.jahmm.io.OpdfWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;

public class HmmWriter {
    public static <O extends Observation> void write(Writer writer, OpdfWriter<? extends Opdf<O>> opdfWriter, Hmm<O> hmm) throws IOException {
        writer.write("Hmm v1.0\n\nNbStates " + hmm.nbStates() + "\n\n");
        for (int k = 0; k < hmm.nbStates(); ++k) {
            HmmWriter.a(writer, opdfWriter, hmm, k);
        }
    }

    private static <O extends Observation, D extends Opdf<O>> void a(Writer writer, OpdfWriter<D> opdfWriter, Hmm<O> hmm, int n) throws IOException {
        DecimalFormat decimalFormat = new DecimalFormat("#0.######");
        writer.write("State\nPi " + decimalFormat.format(hmm.getPi(n)));
        writer.write("\nA ");
        for (int k = 0; k < hmm.nbStates(); ++k) {
            writer.write(decimalFormat.format(hmm.getAij(n, k)) + " ");
        }
        writer.write("\n");
        Opdf<O> opdf = hmm.getOpdf(n);
        opdfWriter.write(writer, opdf);
        writer.write("\n\n");
    }
}

