/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm.io;

import be.ac.ulg.montefiore.run.jahmm.ObservationInteger;
import be.ac.ulg.montefiore.run.jahmm.io.FileFormatException;
import be.ac.ulg.montefiore.run.jahmm.io.ObservationReader;
import be.ac.ulg.montefiore.run.jahmm.io.ObservationSequencesReader;
import java.io.IOException;
import java.io.StreamTokenizer;

public class ObservationIntegerReader
extends ObservationReader<ObservationInteger> {
    private int w;

    public ObservationIntegerReader() {
        this.w = Integer.MAX_VALUE;
    }

    public ObservationIntegerReader(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Nb of elements must be positive");
        }
        this.w = n;
    }

    @Override
    public ObservationInteger read(StreamTokenizer streamTokenizer) throws IOException, FileFormatException {
        streamTokenizer.ordinaryChar(46);
        if (streamTokenizer.nextToken() == -2) {
            if (streamTokenizer.nval > (double)this.w) {
                throw new FileFormatException(streamTokenizer.lineno(), "Integer higher than maximum value " + (this.w - 1));
            }
        } else {
            throw new FileFormatException(streamTokenizer.lineno(), "Integer expected");
        }
        ObservationInteger observationInteger = new ObservationInteger((int)streamTokenizer.nval);
        if (streamTokenizer.nextToken() != 59) {
            throw new FileFormatException(streamTokenizer.lineno(), "';' expected");
        }
        ObservationSequencesReader.b(streamTokenizer);
        return observationInteger;
    }
}

