/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm.io;

import be.ac.ulg.montefiore.run.jahmm.ObservationVector;
import be.ac.ulg.montefiore.run.jahmm.io.FileFormatException;
import be.ac.ulg.montefiore.run.jahmm.io.ObservationReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.ArrayList;

public class ObservationVectorReader
extends ObservationReader<ObservationVector> {
    private int dimension;

    public ObservationVectorReader() {
        this.dimension = -1;
    }

    public ObservationVectorReader(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Argument must be strictly positive");
        }
        this.dimension = n;
    }

    @Override
    public ObservationVector read(StreamTokenizer object) throws IOException, FileFormatException {
        if (((StreamTokenizer)object).nextToken() != 91) {
            throw new FileFormatException(((StreamTokenizer)object).lineno(), "'[' expected");
        }
        ArrayList<Double> arrayList = new ArrayList<Double>();
        block4: while (true) {
            switch (((StreamTokenizer)object).nextToken()) {
                case -2: {
                    arrayList.add(new Double(((StreamTokenizer)object).nval));
                    continue block4;
                }
                case 93: {
                    if (arrayList.size() != 0) break block4;
                    throw new FileFormatException(((StreamTokenizer)object).lineno(), "Empty vector found");
                }
                default: {
                    throw new FileFormatException(((StreamTokenizer)object).lineno(), "Number or ']' expected");
                }
            }
            break;
        }
        if (((StreamTokenizer)object).nextToken() != 59) {
            throw new FileFormatException(((StreamTokenizer)object).lineno(), "';' expected");
        }
        if (this.dimension > 0 && arrayList.size() != this.dimension) {
            throw new FileFormatException(((StreamTokenizer)object).lineno(), "Bad observation: wrong dimension (" + arrayList.size() + " instead of " + this.dimension + ")");
        }
        object = new double[arrayList.size()];
        for (int k = 0; k < arrayList.size(); ++k) {
            object[k] = (Double)arrayList.get(k);
        }
        return new ObservationVector((double[])object);
    }
}

