/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm.learn;

import be.ac.ulg.montefiore.run.jahmm.ForwardBackwardCalculator;
import be.ac.ulg.montefiore.run.jahmm.ForwardBackwardScaledCalculator;
import be.ac.ulg.montefiore.run.jahmm.Hmm;
import be.ac.ulg.montefiore.run.jahmm.Observation;
import be.ac.ulg.montefiore.run.jahmm.learn.BaumWelchLearner;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;

public class BaumWelchScaledLearner
extends BaumWelchLearner {
    @Override
    protected <O extends Observation> ForwardBackwardCalculator a(List<? extends O> list, Hmm<O> hmm) {
        return new ForwardBackwardScaledCalculator(list, hmm, EnumSet.allOf(ForwardBackwardCalculator.Computation.class));
    }

    @Override
    protected <O extends Observation> double[][][] a(List<? extends O> list, ForwardBackwardCalculator forwardBackwardCalculator, Hmm<O> hmm) {
        if (list.size() <= 1) {
            throw new IllegalArgumentException("Observation sequence too short");
        }
        double[][][] dArray = new double[list.size() - 1][hmm.nbStates()][hmm.nbStates()];
        Iterator<O> iterator = list.iterator();
        iterator.next();
        for (int k = 0; k < list.size() - 1; ++k) {
            Observation observation = (Observation)iterator.next();
            for (int i2 = 0; i2 < hmm.nbStates(); ++i2) {
                for (int i3 = 0; i3 < hmm.nbStates(); ++i3) {
                    dArray[k][i2][i3] = forwardBackwardCalculator.alphaElement(k, i2) * hmm.getAij(i2, i3) * hmm.getOpdf(i3).probability(observation) * forwardBackwardCalculator.betaElement(k + 1, i3);
                }
            }
        }
        return dArray;
    }
}

