/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm.learn;

import be.ac.ulg.montefiore.run.jahmm.Hmm;
import be.ac.ulg.montefiore.run.jahmm.Observation;
import be.ac.ulg.montefiore.run.jahmm.Opdf;
import be.ac.ulg.montefiore.run.jahmm.OpdfFactory;
import be.ac.ulg.montefiore.run.jahmm.ViterbiCalculator;
import be.ac.ulg.montefiore.run.jahmm.learn.a;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class KMeansLearner<O extends Observation> {
    private a<O> B;
    private int C;
    private List<? extends List<? extends O>> D;
    private OpdfFactory<? extends Opdf<O>> E;
    private boolean F;

    public KMeansLearner(int n, OpdfFactory<? extends Opdf<O>> object, List<? extends List<? extends O>> list) {
        this.D = list;
        this.E = object;
        this.C = n;
        object = KMeansLearner.a(list);
        this.B = new a(n, object);
        this.F = false;
    }

    public Hmm<O> iterate() {
        Hmm hmm = new Hmm(this.C, this.E);
        this.e(hmm);
        this.f(hmm);
        this.g(hmm);
        this.F = this.h(hmm);
        return hmm;
    }

    public boolean isTerminated() {
        return this.F;
    }

    public Hmm<O> learn() {
        Hmm<O> hmm;
        do {
            hmm = this.iterate();
        } while (!this.isTerminated());
        return hmm;
    }

    private void e(Hmm<?> hmm) {
        double[] dArray = new double[this.C];
        for (int k = 0; k < this.C; ++k) {
            dArray[k] = 0.0;
        }
        for (List<O> list : this.D) {
            int n = this.B.clusterNb((Observation)list.get(0));
            dArray[n] = dArray[n] + 1.0;
        }
        for (int k = 0; k < this.C; ++k) {
            hmm.setPi(k, dArray[k] / (double)this.D.size());
        }
    }

    private void f(Hmm<O> hmm) {
        int n;
        for (int k = 0; k < hmm.nbStates(); ++k) {
            for (int i2 = 0; i2 < hmm.nbStates(); ++i2) {
                hmm.setAij(k, i2, 0.0);
            }
        }
        for (List<O> list : this.D) {
            if (list.size() < 2) continue;
            n = this.B.clusterNb((Observation)list.get(0));
            for (int k = 1; k < list.size(); ++k) {
                int n2 = n;
                n = this.B.clusterNb((Observation)list.get(k));
                hmm.setAij(n2, n, hmm.getAij(n2, n) + 1.0);
            }
        }
        for (int k = 0; k < hmm.nbStates(); ++k) {
            double d2 = 0.0;
            for (n = 0; n < hmm.nbStates(); ++n) {
                d2 += hmm.getAij(k, n);
            }
            if (d2 == 0.0) {
                for (n = 0; n < hmm.nbStates(); ++n) {
                    hmm.setAij(k, n, 1.0 / (double)hmm.nbStates());
                }
                continue;
            }
            for (n = 0; n < hmm.nbStates(); ++n) {
                hmm.setAij(k, n, hmm.getAij(k, n) / d2);
            }
        }
    }

    private void g(Hmm<O> hmm) {
        for (int k = 0; k < hmm.nbStates(); ++k) {
            Collection<O> collection = this.B.cluster(k);
            if (collection.isEmpty()) {
                hmm.setOpdf(k, this.E.factor());
                continue;
            }
            hmm.getOpdf(k).fit(collection);
        }
    }

    private boolean h(Hmm<O> hmm) {
        boolean bl = false;
        for (List<O> list : this.D) {
            Object object = new ViterbiCalculator(list, hmm);
            object = ((ViterbiCalculator)object).stateSequence();
            for (int k = 0; k < ((Object)object).length; ++k) {
                Observation observation = (Observation)list.get(k);
                if (this.B.clusterNb(observation) == object[k]) continue;
                bl = true;
                this.B.remove(observation, this.B.clusterNb(observation));
                this.B.put(observation, (int)object[k]);
            }
        }
        return !bl;
    }

    static <T> List<T> a(List<? extends List<? extends T>> object) {
        ArrayList arrayList = new ArrayList();
        object = object.iterator();
        while (object.hasNext()) {
            List list = (List)object.next();
            arrayList.addAll(list);
        }
        return arrayList;
    }
}

