/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm.toolbox;

import be.ac.ulg.montefiore.run.jahmm.ForwardBackwardScaledCalculator;
import be.ac.ulg.montefiore.run.jahmm.Hmm;
import be.ac.ulg.montefiore.run.jahmm.Observation;
import be.ac.ulg.montefiore.run.jahmm.toolbox.MarkovGenerator;
import java.util.List;

public class KullbackLeiblerDistanceCalculator {
    private int G = 1000;
    private int H = 10;

    public <O extends Observation> double distance(Hmm<O> hmm, Hmm<? super O> hmm2) {
        double d2 = 0.0;
        for (int k = 0; k < this.H; ++k) {
            List<O> list = new MarkovGenerator<O>(hmm).observationSequence(this.G);
            d2 += (new ForwardBackwardScaledCalculator(list, hmm).lnProbability() - new ForwardBackwardScaledCalculator(list, hmm2).lnProbability()) / (double)this.G;
        }
        return d2 / (double)this.H;
    }

    public int getNbSequences() {
        return this.H;
    }

    public void setNbSequences(int n) {
        this.H = n;
    }

    public int getSequencesLength() {
        return this.G;
    }

    public void setSequencesLength(int n) {
        this.G = n;
    }
}

