/*
 * Decompiled with CFR 0.152.
 */
package be.ac.ulg.montefiore.run.jahmm.toolbox;

import be.ac.ulg.montefiore.run.jahmm.Hmm;
import be.ac.ulg.montefiore.run.jahmm.Observation;
import java.util.ArrayList;
import java.util.List;

public class MarkovGenerator<O extends Observation> {
    private final Hmm<O> I;
    private int J;

    public MarkovGenerator(Hmm<O> hmm) {
        if (hmm == null) {
            throw new IllegalArgumentException("Invalid null HMM");
        }
        this.I = hmm;
        this.newSequence();
    }

    public O observation() {
        O o = this.I.getOpdf(this.J).generate();
        double d2 = Math.random();
        for (int k = 0; k < this.I.nbStates() - 1; ++k) {
            double d3;
            d2 -= this.I.getAij(this.J, k);
            if (!(d3 < 0.0)) continue;
            this.J = k;
            return o;
        }
        this.J = this.I.nbStates() - 1;
        return o;
    }

    public List<O> observationSequence(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Positive length required");
        }
        ArrayList<O> arrayList = new ArrayList<O>();
        while (n-- > 0) {
            arrayList.add(this.observation());
        }
        this.newSequence();
        return arrayList;
    }

    public void newSequence() {
        double d2 = Math.random();
        double d3 = 0.0;
        for (int k = 0; k < this.I.nbStates() - 1; ++k) {
            double d4;
            d3 += this.I.getPi(k);
            if (!(d4 > d2)) continue;
            this.J = k;
            return;
        }
        this.J = this.I.nbStates() - 1;
    }

    public int stateNb() {
        return this.J;
    }
}

