/*
 * Decompiled with CFR 0.152.
 */
package nl.liacs.dbdm.ftse.distribution;

import be.ac.ulg.montefiore.run.distributions.MultiGaussianDistribution;
import be.ac.ulg.montefiore.run.distributions.MultiRandomDistribution;
import java.util.Random;

public class MultiGaussianMixtureDistribution
implements MultiRandomDistribution {
    private static final long serialVersionUID = -1484990992176542812L;
    private static final Random RANDOM = new Random();
    protected MultiGaussianDistribution[] components;
    protected double[] mixtures;

    public MultiGaussianMixtureDistribution(MultiGaussianDistribution[] multiGaussianDistributionArray, double[] dArray) {
        int n;
        this.components = (MultiGaussianDistribution[])multiGaussianDistributionArray.clone();
        this.mixtures = (double[])dArray.clone();
        double d2 = 0.0;
        for (n = 0; n < dArray.length; ++n) {
            d2 += dArray[n];
        }
        for (n = 0; n < dArray.length; ++n) {
            this.mixtures[n] = dArray[n] / d2;
        }
    }

    public int nbGaussians() {
        return this.components.length;
    }

    public MultiGaussianDistribution[] distributions() {
        return (MultiGaussianDistribution[])this.components.clone();
    }

    public double[] proportions() {
        return (double[])this.mixtures.clone();
    }

    @Override
    public int dimension() {
        return this.components[0].dimension();
    }

    @Override
    public double[] generate() {
        double d2 = RANDOM.nextDouble();
        double d3 = 0.0;
        for (int k = 0; k < this.mixtures.length; ++k) {
            if (!(d2 <= (d3 += this.mixtures[k]))) continue;
            return this.components[k].generate();
        }
        throw new RuntimeException("Internal Error");
    }

    @Override
    public double probability(double[] dArray) {
        double d2 = 0.0;
        for (int k = 0; k < this.components.length; ++k) {
            d2 += this.components[k].probability(dArray) * this.mixtures[k];
        }
        return d2;
    }

    public MultiGaussianMixtureDistribution clone() {
        return new MultiGaussianMixtureDistribution(this.components, this.mixtures);
    }
}

