/*
 * Decompiled with CFR 0.152.
 */
package nl.liacs.dbdm.ftse.distribution;

import be.ac.ulg.montefiore.run.distributions.MultiGaussianDistribution;
import be.ac.ulg.montefiore.run.jahmm.ObservationVector;
import be.ac.ulg.montefiore.run.jahmm.Opdf;
import be.ac.ulg.montefiore.run.jahmm.OpdfMultiGaussian;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collection;
import nl.liacs.dbdm.ftse.distribution.MultiGaussianMixtureDistribution;
import org.apache.commons.math.linear.MatrixUtils;
import org.apache.commons.math.linear.RealMatrix;
import org.apache.commons.math.linear.RealVector;
import org.apache.commons.math.stat.StatUtils;
import org.apache.commons.math.stat.correlation.Covariance;

public class OpdfMultiGaussianMixture<O extends ObservationVector>
implements Opdf<O> {
    private static final long serialVersionUID = 4057179251746887056L;
    private MultiGaussianMixtureDistribution distribution;

    public OpdfMultiGaussianMixture(MultiGaussianMixtureDistribution multiGaussianMixtureDistribution) {
        this.distribution = multiGaussianMixtureDistribution;
    }

    @Override
    public double probability(ObservationVector observationVector) {
        return this.distribution.probability(observationVector.values());
    }

    @Override
    public O generate() {
        return (O)new ObservationVector(this.distribution.generate());
    }

    public int nbGaussians() {
        return this.distribution.nbGaussians();
    }

    public double[] propportions() {
        return this.distribution.proportions();
    }

    public MultiGaussianMixtureDistribution getDistribution() {
        return this.distribution;
    }

    @Override
    public void fit(Collection<? extends O> collection) {
        double[] dArray = new double[collection.size()];
        Arrays.fill(dArray, 1.0 / (double)collection.size());
        this.fit(collection, dArray);
    }

    @Override
    public void fit(Collection<? extends O> collection, double[] dArray) {
        Collection<O> collection2 = collection;
        Object[] objectArray = collection2.toArray(new ObservationVector[collection2.size()]);
        RealMatrix realMatrix = this.a((ObservationVector[])objectArray);
        int n = this.distribution.nbGaussians();
        Object object = this.b((ObservationVector[])objectArray);
        objectArray = this.a((double[][])object, (ObservationVector[])objectArray, dArray);
        object = MatrixUtils.createRealMatrix((double[][])object);
        object = MatrixUtils.createRealVector((double[])dArray);
        object = new MultiGaussianDistribution[this.distribution.nbGaussians()];
        MultiGaussianDistribution[] multiGaussianDistributionArray = this.distribution.distributions();
        for (int k = 0; k < n; ++k) {
            OpdfMultiGaussian opdfMultiGaussian = new OpdfMultiGaussian(multiGaussianDistributionArray[k].mean(), multiGaussianDistributionArray[k].covariance());
            opdfMultiGaussian.fit((Collection<? extends ObservationVector>)collection, dArray);
            object[k] = (double[])new MultiGaussianDistribution(opdfMultiGaussian.mean(), opdfMultiGaussian.covariance());
        }
        this.distribution = new MultiGaussianMixtureDistribution((MultiGaussianDistribution[])object, (double[])objectArray);
    }

    private RealMatrix a(ObservationVector[] observationVectorArray) {
        int n = observationVectorArray[0].dimension();
        RealMatrix realMatrix = MatrixUtils.createRealMatrix((int)observationVectorArray.length, (int)n);
        for (int k = 0; k < observationVectorArray.length; ++k) {
            for (int i2 = 0; i2 < n; ++i2) {
                realMatrix.setEntry(k, i2, observationVectorArray[k].value(i2));
            }
        }
        return realMatrix;
    }

    private double[][] b(ObservationVector[] observationVectorArray) {
        double[][] dArray = new double[this.distribution.nbGaussians()][observationVectorArray.length];
        MultiGaussianDistribution[] multiGaussianDistributionArray = this.distribution.distributions();
        double[] dArray2 = this.distribution.proportions();
        for (int k = 0; k < this.distribution.nbGaussians(); ++k) {
            for (int i2 = 0; i2 < observationVectorArray.length; ++i2) {
                double d2 = multiGaussianDistributionArray[k].probability(observationVectorArray[i2].values());
                double d3 = this.probability(observationVectorArray[i2]);
                dArray[k][i2] = d2 == 0.0 || d3 == 0.0 || dArray2[k] == 0.0 ? 0.0 : dArray2[k] * d2 / d3;
            }
        }
        return dArray;
    }

    private double[] a(double[][] dArray, ObservationVector[] objectArray, double[] dArray2) {
        int n;
        objectArray = (double[])this.distribution.proportions().clone();
        double d2 = 0.0;
        for (n = 0; n < this.distribution.nbGaussians(); ++n) {
            for (int k = 0; k < dArray2.length; ++k) {
                double d3 = dArray2[k] * dArray[n][k];
                int n2 = n;
                objectArray[n2] = objectArray[n2] + d3;
                d2 += d3;
            }
        }
        if (d2 != 0.0) {
            for (n = 0; n < objectArray.length; ++n) {
                objectArray[n] = objectArray[n] / d2;
            }
        }
        return objectArray;
    }

    private double[] a(RealMatrix realMatrix, RealMatrix realMatrix2, RealVector realVector, int n) {
        realMatrix = realMatrix.transpose();
        double[] dArray = new double[this.distribution.dimension()];
        int n2 = 0;
        for (int k = 0; k < this.distribution.dimension(); ++k) {
            RealVector realVector2 = realMatrix2.getColumnVector(k);
            RealVector realVector3 = realMatrix.getColumnVector(k).ebeMultiply(realVector);
            dArray[n2++] = StatUtils.mean((double[])realVector2.ebeMultiply(realVector3).getData());
        }
        return dArray;
    }

    private double[][] b(RealMatrix realMatrix, RealMatrix realMatrix2, RealVector realVector, int n) {
        realMatrix2 = realMatrix2.copy();
        for (int k = 0; k < realMatrix2.getRowDimension(); ++k) {
            for (int i2 = 0; i2 < realMatrix2.getColumnDimension(); ++i2) {
                realMatrix2.setEntry(k, i2, realMatrix2.getEntry(k, i2) * realVector.getEntry(i2) * realMatrix.getEntry(i2, k));
            }
        }
        RealMatrix realMatrix3 = realMatrix2.getSubMatrix(this.b(0, realMatrix2.getRowDimension()), this.a(realMatrix2, n));
        return new Covariance(realMatrix2).getCovarianceMatrix().getData();
    }

    private int[] a(RealMatrix realMatrix, int n) {
        int[] nArray = new int[realMatrix.getColumnDimension() - 1];
        int n2 = 0;
        for (int k = 0; k < realMatrix.getColumnDimension(); ++k) {
            if (k == n) continue;
            nArray[n2++] = k;
        }
        return nArray;
    }

    private int[] b(int n, int n2) {
        int[] nArray = new int[n2 - n];
        n2 = 0;
        while (n2 < nArray.length) {
            int n3 = n2++;
            nArray[n3] = n3;
        }
        return nArray;
    }

    @Override
    public void fit(O[] OArray, double[] dArray) {
        this.fit((Collection<? extends O>)Arrays.asList(OArray), dArray);
    }

    @Override
    public void fit(O ... OArray) {
        this.fit((Collection<? extends O>)Arrays.asList(OArray));
    }

    @Override
    public Opdf<O> clone() {
        return new OpdfMultiGaussianMixture<O>(this.distribution.clone());
    }

    @Override
    public String toString(NumberFormat numberFormat) {
        return this.toString();
    }
}

