/*
 * Decompiled with CFR 0.152.
 */
package com.skysharing.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.skysharing.api.Signer;
import com.skysharing.api.exception.InvalidPrivateKeyException;
import com.skysharing.api.exception.InvalidPublicKeyException;
import com.skysharing.api.exception.RequestFailedException;
import com.skysharing.api.exception.ResponseNotValidException;
import com.skysharing.api.exception.SignException;
import com.skysharing.api.request.CassPayRequest;
import com.skysharing.api.response.CassPayResponse;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class DefaultCassPayClient {
    public static final Signer signer = new Signer();
    private final String url;
    private final String appId;
    private final PrivateKey appPrivateKey;
    private final PublicKey cassPublicKey;
    private final String format;
    private final String signType;
    private OkHttpClient client;
    private DateTimeFormatter datetimeFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private Boolean debug = false;

    public DefaultCassPayClient(String url, String appId, String appPrivateKey, String cassPublicKey, String format, String signType) throws InvalidPrivateKeyException, InvalidPublicKeyException {
        this.url = url;
        this.appId = appId;
        this.appPrivateKey = signer.getPrivateKey(appPrivateKey);
        this.cassPublicKey = signer.getPublicKey(cassPublicKey);
        this.format = format;
        this.signType = signType;
        this.setTimeout(TimeUnit.SECONDS, 30, 30, 30);
    }

    public DefaultCassPayClient(String url, String appId, String appPrivateKey, String cassPublicKey) throws InvalidPrivateKeyException, InvalidPublicKeyException {
        this.url = url;
        this.appId = appId;
        this.appPrivateKey = signer.getPrivateKey(appPrivateKey);
        this.cassPublicKey = signer.getPublicKey(cassPublicKey);
        this.format = "JSON";
        this.signType = "RSA2";
        this.setTimeout(TimeUnit.SECONDS, 30, 30, 30);
    }

    public DefaultCassPayClient setTimeout(TimeUnit unit, Integer connectTimeout, Integer writeTimeout, Integer readTimeout) {
        this.client = new OkHttpClient.Builder().connectTimeout((long)connectTimeout.intValue(), unit).writeTimeout((long)writeTimeout.intValue(), unit).readTimeout((long)readTimeout.intValue(), unit).build();
        return this;
    }

    public DefaultCassPayClient setDebug(Boolean debug) {
        this.debug = debug;
        return this;
    }

    public <T extends CassPayRequest, F extends CassPayResponse> F execute(T request) throws SignException, RequestFailedException, ResponseNotValidException {
        String responseKey;
        String queryStr;
        JSONObject response;
        request.url = this.url;
        request.APPID = this.appId;
        request.format = this.format;
        request.signType = this.signType;
        request.privateKey = this.appPrivateKey;
        request.datetime = LocalDateTime.now().format(this.datetimeFormat);
        JSONObject params = request.buildParams();
        if (this.debug.booleanValue()) {
            System.out.println("Request: " + request.toString());
            System.out.println("Request JSON: " + params);
        }
        if (!(response = this.post(queryStr = signer.httpBuildQuery((Map)JSON.toJavaObject((JSON)params, Map.class)))).containsKey((Object)(responseKey = request.getResponseKeyName()))) {
            throw new ResponseNotValidException("\u54cd\u5e94\u4e2d\u5fc5\u987b\u8981\u6709" + responseKey + "\u952e");
        }
        if (!response.containsKey((Object)"sign")) {
            throw new ResponseNotValidException("\u54cd\u5e94\u4e2d\u5fc5\u987b\u8981\u6709sign\u952e");
        }
        Object cassResponse = request.makeResponse(response.getJSONObject(responseKey));
        if (this.debug.booleanValue()) {
            System.out.println("Response JSON: " + ((CassPayResponse)cassResponse).raw);
        }
        ((CassPayResponse)cassResponse).sign = response.getString("sign");
        ((CassPayResponse)cassResponse).request = request;
        ((CassPayResponse)cassResponse).vzhuoPublicKey = this.cassPublicKey;
        return (F)cassResponse;
    }

    private JSONObject post(String queryStr) throws RequestFailedException {
        JSONObject jSONObject;
        block8: {
            RequestBody body = RequestBody.create((String)queryStr, (MediaType)MediaType.get((String)"application/html; charset=utf-8"));
            Request request = new Request.Builder().url(this.url).post(body).build();
            Response response = this.client.newCall(request).execute();
            try {
                jSONObject = JSON.parseObject((String)response.body().string());
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new RequestFailedException("\u8bf7\u6c42\u5931\u8d25: " + e.getMessage());
                }
            }
            response.close();
        }
        return jSONObject;
    }
}

