/*
 * Decompiled with CFR 0.152.
 */
package com.skysharing.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.skysharing.api.exception.InvalidPrivateKeyException;
import com.skysharing.api.exception.InvalidPublicKeyException;
import com.skysharing.api.exception.SignException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.Iterator;
import java.util.Map;

public class Signer {
    public static final String ALGORITHM = "RSA";
    public static final String SIGNATURE_ALGORITHM = "SHA256WithRSA";

    public PublicKey getPublicKey(String key) throws InvalidPublicKeyException {
        try {
            byte[] keyBytes = Base64.getDecoder().decode(key);
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM);
            PublicKey publicKey = keyFactory.generatePublic(keySpec);
            return publicKey;
        }
        catch (Exception e) {
            throw new InvalidPublicKeyException(e.getMessage());
        }
    }

    public PrivateKey getPrivateKey(String key) throws InvalidPrivateKeyException {
        try {
            byte[] keyBytes = Base64.getDecoder().decode(key);
            KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM);
            return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(keyBytes));
        }
        catch (Exception e) {
            throw new InvalidPrivateKeyException(e.getMessage());
        }
    }

    public String sign(String str, PrivateKey privateKey) throws SignException {
        try {
            Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
            signature.initSign(privateKey);
            signature.update(str.getBytes(StandardCharsets.UTF_8));
            return Base64.getEncoder().encodeToString(signature.sign());
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            e.printStackTrace();
            throw new SignException("\u7b7e\u540d\u5931\u8d25: " + e.getMessage());
        }
    }

    public String singParams(JSONObject params, PrivateKey privateKey) throws SignException {
        String waitSignStr = this.paramsToWaitSignStr(params);
        return this.sign(waitSignStr, privateKey);
    }

    public Boolean verifyParams(JSONObject params, PublicKey publicKey, String sign) throws Exception {
        String str = this.paramsToWaitVerifyStr(params);
        return this.verify(str, publicKey, sign);
    }

    public Boolean verify(String str, PublicKey publicKey, String sign) throws Exception {
        Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
        signature.initVerify(publicKey);
        signature.update(str.getBytes(StandardCharsets.UTF_8));
        return signature.verify(Base64.getDecoder().decode(sign));
    }

    public JSONObject filterParams(JSONObject params) {
        String key;
        JSONObject filteredParams = new JSONObject();
        Iterator iterator = params.keySet().iterator();
        while (iterator.hasNext() && !params.getString(key = (String)iterator.next()).equals("") && !params.getString(key).equals("{}") && !params.getString(key).equals("[]")) {
            filteredParams.put(key, (Object)params.getString(key));
        }
        return filteredParams;
    }

    public String paramsToWaitSignStr(JSONObject params) {
        SerializerFeature[] serializerFeatureArray = new SerializerFeature[2];
        serializerFeatureArray[0] = SerializerFeature.MapSortField;
        serializerFeatureArray[1] = SerializerFeature.WriteSlashAsSpecial;
        String newStr = JSON.toJSONString((Object)this.filterParams(params), (SerializerFeature[])serializerFeatureArray);
        newStr = newStr.replace(" ", "");
        try {
            newStr = URLEncoder.encode(newStr, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        newStr = newStr.replace("*", "%2A");
        return newStr;
    }

    public String paramsToWaitVerifyStr(JSONObject params) {
        SerializerFeature[] serializerFeatureArray = new SerializerFeature[2];
        serializerFeatureArray[0] = SerializerFeature.MapSortField;
        serializerFeatureArray[1] = SerializerFeature.WriteSlashAsSpecial;
        String newStr = JSON.toJSONString((Object)params, (SerializerFeature[])serializerFeatureArray);
        try {
            newStr = URLEncoder.encode(newStr, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        newStr = newStr.replace("*", "%2A");
        return newStr;
    }

    public String httpBuildQuery(Map<String, String> map) {
        StringBuffer sb = new StringBuffer();
        if (map.size() > 0) {
            for (String key : map.keySet()) {
                sb.append(key + "=");
                if (map.get(key).equals("")) {
                    sb.append("&");
                    continue;
                }
                String value = map.get(key);
                try {
                    value = URLEncoder.encode(value, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                sb.append(value + "&");
            }
        }
        return sb.toString();
    }
}

