/*
 * Decompiled with CFR 0.152.
 */
package com.skysharing.api.response;

import com.alibaba.fastjson.JSONObject;
import com.skysharing.api.Signer;
import com.skysharing.api.request.CassPayRequest;
import java.security.PublicKey;

public class CassPayResponse<T extends CassPayRequest> {
    public String code;
    public String message;
    public String subCode;
    public String subMsg;
    public JSONObject content;
    public String sign;
    public T request;
    public JSONObject raw;
    public PublicKey vzhuoPublicKey;

    public CassPayResponse(JSONObject response) {
        this.raw = response;
        this.code = response.getString("code");
        this.subCode = response.getString("subCode");
        this.subMsg = response.getString("subMsg");
        this.message = response.getString("message");
        this.content = response.getString("content").equals("[]") ? new JSONObject() : response.getJSONObject("content");
    }

    public boolean verify() throws Exception {
        Signer signer = new Signer();
        return signer.verifyParams(this.raw, this.vzhuoPublicKey, this.sign);
    }

    public String toString() {
        return "CassPayResponse{code='" + this.code + '\'' + ", message='" + this.message + '\'' + ", subCode='" + this.subCode + '\'' + ", subMsg='" + this.subMsg + '\'' + ", content=" + this.content + '}';
    }

    public Boolean isSuccess() {
        return this.isRequestSuccess() != false && this.code.equals("10000");
    }

    public Boolean isRequestSuccess() {
        if (this.sign == null || this.sign.equals("")) {
            return false;
        }
        return this.code != null && !this.code.equals("");
    }
}

