/*
 * Decompiled with CFR 0.152.
 */
package com.github.zhengframework.configuration;

import com.github.zhengframework.configuration.Configuration;
import com.github.zhengframework.configuration.MapConfiguration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.stream.Collectors;
import org.apache.commons.collections4.trie.PatriciaTrie;

public abstract class AbstractConfiguration
implements Configuration {
    public static void checkPrefix(String prefix) {
        if (prefix == null || prefix.length() == 0) {
            throw new RuntimeException("invalid prefix");
        }
    }

    @Override
    public Configuration prefix(String prefix) {
        AbstractConfiguration.checkPrefix(prefix);
        PatriciaTrie patriciaTrie = new PatriciaTrie(this.asMap());
        SortedMap prefixMap = patriciaTrie.prefixMap((Object)(prefix + "."));
        int len = prefix.length() + 1;
        return new MapConfiguration(prefixMap.entrySet().stream().collect(Collectors.toMap(entry -> ((String)entry.getKey()).substring(len), Map.Entry::getValue)));
    }

    @Override
    public List<Configuration> prefixList(String prefix) {
        AbstractConfiguration.checkPrefix(prefix);
        PatriciaTrie patriciaTrie = new PatriciaTrie(this.asMap());
        SortedMap prefixMap = patriciaTrie.prefixMap((Object)(prefix + "."));
        int len = prefix.length() + 1;
        HashMap map = new HashMap();
        for (Map.Entry entry2 : prefixMap.entrySet()) {
            int index;
            String key = ((String)entry2.getKey()).substring(len);
            if (key.contains(".")) {
                int index2;
                String indexKey = key.substring(0, key.indexOf("."));
                if (indexKey.length() == 0) {
                    throw new RuntimeException("parse index error, key=" + key);
                }
                try {
                    index2 = Integer.parseInt(key.substring(0, key.indexOf(".")));
                }
                catch (NumberFormatException e) {
                    throw new RuntimeException("parse index error, key=" + key);
                }
                String newKey = key.substring(key.indexOf(".") + 1);
                if (newKey.length() == 0) {
                    throw new RuntimeException("parse configuration key error, key=" + key);
                }
                if (!map.containsKey(index2)) {
                    map.put(index2, new HashMap());
                }
                ((Map)map.get(index2)).put(newKey, entry2.getValue());
                continue;
            }
            try {
                index = Integer.parseInt(key);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("parse index error, key=" + key);
            }
            String newKey = "";
            if (!map.containsKey(index)) {
                map.put(index, new HashMap());
            }
            ((Map)map.get(index)).put(newKey, entry2.getValue());
        }
        return map.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(entry -> new MapConfiguration((Map)entry.getValue())).collect(Collectors.toList());
    }

    @Override
    public Set<Configuration> prefixSet(String prefix) {
        AbstractConfiguration.checkPrefix(prefix);
        PatriciaTrie patriciaTrie = new PatriciaTrie(this.asMap());
        SortedMap prefixMap = patriciaTrie.prefixMap((Object)(prefix + "."));
        int len = prefix.length() + 1;
        HashMap map = new HashMap();
        for (Map.Entry entry : prefixMap.entrySet()) {
            int index;
            String key = ((String)entry.getKey()).substring(len);
            if (key.contains(".")) {
                int index2;
                String indexKey = key.substring(0, key.indexOf("."));
                if (indexKey.length() == 0) {
                    throw new RuntimeException("parse index error, key=" + key);
                }
                try {
                    index2 = Integer.parseInt(key.substring(0, key.indexOf(".")));
                }
                catch (NumberFormatException e) {
                    throw new RuntimeException("parse index error, key=" + key);
                }
                String newKey = key.substring(key.indexOf(".") + 1);
                if (newKey.length() == 0) {
                    throw new RuntimeException("parse configuration key error, key=" + key);
                }
                if (!map.containsKey(index2)) {
                    map.put(index2, new HashMap());
                }
                ((Map)map.get(index2)).put(newKey, entry.getValue());
                continue;
            }
            try {
                index = Integer.parseInt(key);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("parse index error, key=" + key);
            }
            String newKey = "";
            if (!map.containsKey(index)) {
                map.put(index, new HashMap());
            }
            ((Map)map.get(index)).put(newKey, entry.getValue());
        }
        return map.values().stream().map(MapConfiguration::new).collect(Collectors.toSet());
    }

    @Override
    public Map<String, Configuration> prefixMap(String prefix) {
        AbstractConfiguration.checkPrefix(prefix);
        PatriciaTrie patriciaTrie = new PatriciaTrie(this.asMap());
        SortedMap prefixMap = patriciaTrie.prefixMap((Object)(prefix + "."));
        int len = prefix.length() + 1;
        HashMap map = new HashMap();
        for (Map.Entry entry2 : prefixMap.entrySet()) {
            String key = ((String)entry2.getKey()).substring(len);
            if (!key.contains(".")) continue;
            String mapKey = key.substring(0, key.indexOf("."));
            if (mapKey.length() == 0) {
                throw new RuntimeException("parse map key error, key=" + key);
            }
            String newKey = key.substring(key.indexOf(".") + 1);
            if (newKey.length() == 0) {
                throw new RuntimeException("parse configuration key error, key=" + key);
            }
            if (!map.containsKey(mapKey)) {
                map.put(mapKey, new HashMap());
            }
            ((Map)map.get(mapKey)).put(newKey, entry2.getValue());
        }
        return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new MapConfiguration((Map)entry.getValue())));
    }
}

