/*
 * Decompiled with CFR 0.152.
 */
package com.github.zhengframework.configuration;

import com.fasterxml.jackson.dataformat.javaprop.JavaPropsMapper;
import com.github.zhengframework.configuration.ConfigurationDefine;
import com.github.zhengframework.configuration.annotation.ConfigurationExample;
import com.github.zhengframework.configuration.annotation.ConfigurationInfo;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;

public class ConfigurationDefineUtils {
    private static JavaPropsMapper javaPropsMapper = new JavaPropsMapper();

    public static void print(Iterator<ConfigurationDefine> iterator, PrintWriter writer) throws Exception {
        while (iterator.hasNext()) {
            ConfigurationDefine define = iterator.next();
            Class<?> aClass = define.getClass();
            ConfigurationDefineUtils.checkConfigurationDefine(aClass);
            ConfigurationInfo configurationInfo = aClass.getAnnotation(ConfigurationInfo.class);
            String prefix = configurationInfo.prefix();
            if (configurationInfo.examples().length > 0) {
                if (Arrays.stream(configurationInfo.examples()).anyMatch(example -> !example.groupName().isEmpty())) {
                    writer.print(prefix);
                    writer.print(".");
                    writer.println("group=true");
                }
                for (ConfigurationExample example2 : configurationInfo.examples()) {
                    Map map = javaPropsMapper.writeValueAsMap((Object)example2.example().newInstance());
                    for (Map.Entry entry : map.entrySet()) {
                        if (!prefix.isEmpty()) {
                            writer.print(prefix);
                            writer.print(".");
                        }
                        if (!example2.groupName().isEmpty()) {
                            writer.print(example2.groupName());
                            writer.print(".");
                        }
                        writer.print((String)entry.getKey());
                        writer.print("=");
                        writer.println((String)entry.getValue());
                    }
                }
            } else {
                Map map = javaPropsMapper.writeValueAsMap((Object)define);
                for (Map.Entry entry : map.entrySet()) {
                    if (!prefix.isEmpty()) {
                        writer.print(prefix);
                        writer.print(".");
                    }
                    writer.print((String)entry.getKey());
                    writer.print("=");
                    writer.println((String)entry.getValue());
                }
            }
            writer.flush();
        }
        writer.flush();
    }

    public static void checkConfigurationDefine(Class<?> aClass) {
        if (!aClass.isAnnotationPresent(ConfigurationInfo.class)) {
            throw new IllegalStateException(aClass.getName() + " is not annotation present @ConfigurationInfo");
        }
    }

    public static void print(PrintWriter writer) throws Exception {
        ServiceLoader<ConfigurationDefine> loader = ServiceLoader.load(ConfigurationDefine.class);
        Iterator<ConfigurationDefine> iterator = loader.iterator();
        ConfigurationDefineUtils.print(iterator, writer);
    }
}

