/*
 * Decompiled with CFR 0.152.
 */
package com.github.zhengframework.configuration;

import com.github.zhengframework.configuration.Configuration;
import com.github.zhengframework.configuration.ex.UnresolvablePlaceholdersException;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PlaceHolder {
    private static final Pattern PATTERN = Pattern.compile("\\$\\{(.+?)}");
    private final Configuration configuration;

    public PlaceHolder(Configuration configuration) {
        this.configuration = configuration;
    }

    public String replace(String source) {
        if (source == null) {
            return null;
        }
        Matcher m = PATTERN.matcher(source);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String var = m.group(1);
            Optional<String> value = this.configuration.get(var);
            if (!value.isPresent()) {
                throw new UnresolvablePlaceholdersException(var);
            }
            String replacement = this.replace(value.get());
            m.appendReplacement(sb, Matcher.quoteReplacement(replacement));
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public String replace(String source, Object ... args) {
        if (source == null) {
            return null;
        }
        Matcher m = PATTERN.matcher(source);
        return m.find() ? this.replace(source) : String.format(source, args);
    }
}

