/*
 * Decompiled with CFR 0.152.
 */
package com.github.zhengframework.core;

import com.google.inject.Binding;
import com.google.inject.Injector;
import java.lang.annotation.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationScanner<T> {
    private static final Logger log = LoggerFactory.getLogger(AnnotationScanner.class);
    private final Injector injector;
    private final Class<? extends Annotation> scanFor;

    public AnnotationScanner(Injector injector, Class<? extends Annotation> scanFor) {
        this.injector = injector;
        this.scanFor = scanFor;
    }

    public void accept(Visitor<T> visitor) {
        this.accept(this.injector, visitor);
    }

    private void accept(Injector inj, Visitor<T> visitor) {
        if (inj == null) {
            return;
        }
        this.accept(inj.getParent(), visitor);
        for (Binding binding : inj.getBindings().values()) {
            Class rawType = binding.getKey().getTypeLiteral().getRawType();
            if (rawType == null || !rawType.isAnnotationPresent(this.scanFor)) continue;
            log.debug("{} rawType={}", this.scanFor, (Object)rawType);
            visitor.visit(binding.getProvider().get());
        }
    }

    public static interface Visitor<V> {
        public void visit(V var1);
    }
}

