/*
 * Decompiled with CFR 0.152.
 */
package com.github.zhengframework.core;

import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.multibindings.MapBinderBinding;
import com.google.inject.multibindings.MultibinderBinding;
import com.google.inject.multibindings.MultibindingsTargetVisitor;
import com.google.inject.multibindings.OptionalBinderBinding;
import com.google.inject.spi.DefaultBindingTargetVisitor;
import com.google.inject.spi.LinkedKeyBinding;
import java.lang.reflect.Modifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassScanner<T> {
    private static final Logger log = LoggerFactory.getLogger(ClassScanner.class);
    private final Injector injector;
    private final Class<T> scanFor;

    public ClassScanner(Injector injector, Class<T> scanFor) {
        this.injector = injector;
        this.scanFor = scanFor;
    }

    private static boolean isConcrete(Class<?> type) {
        return !type.isInterface() && !Modifier.isAbstract(type.getModifiers());
    }

    public static <T> Class<? extends T> getTargetClass(Binding<T> binding) {
        if (binding != null) {
            return (Class)binding.acceptTargetVisitor(new BindingInspectorVisitor());
        }
        return null;
    }

    public void accept(Visitor<T> visitor) {
        this.accept(this.injector, visitor);
    }

    private void accept(Injector inj, Visitor<T> visitor) {
        if (inj == null) {
            return;
        }
        this.accept(inj.getParent(), visitor);
        for (Binding binding : inj.getBindings().values()) {
            Class type = binding.getKey().getTypeLiteral().getRawType();
            if (type == null) continue;
            Class<T> targetType = ClassScanner.getTargetClass(binding);
            if (targetType != null) {
                if (!ClassScanner.isConcrete(targetType) || !this.scanFor.isAssignableFrom(targetType)) continue;
                log.debug("{} targetType={}", this.scanFor, targetType);
                visitor.visit(binding.getProvider().get());
                continue;
            }
            if (!ClassScanner.isConcrete(type) || !this.scanFor.isAssignableFrom(type)) continue;
            log.debug("{} type={}", this.scanFor, (Object)type);
            visitor.visit(binding.getProvider().get());
        }
    }

    private static final class BindingInspectorVisitor<T, C extends Class<? extends T>>
    extends DefaultBindingTargetVisitor<T, C>
    implements MultibindingsTargetVisitor<T, C> {
        private BindingInspectorVisitor() {
        }

        public C visit(LinkedKeyBinding<? extends T> binding) {
            return (C)binding.getLinkedKey().getTypeLiteral().getRawType();
        }

        public C visit(MultibinderBinding<? extends T> multibinderBinding) {
            return null;
        }

        public C visit(MapBinderBinding<? extends T> mapBinderBinding) {
            return null;
        }

        public C visit(OptionalBinderBinding<? extends T> optionalBinderBinding) {
            return null;
        }
    }

    public static interface Visitor<V> {
        public void visit(V var1);
    }
}

