/*
 * Decompiled with CFR 0.152.
 */
package com.github.zhengframework.guice;

import com.github.zhengframework.guice.MethodPostProcessor;
import com.github.zhengframework.guice.Utils;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.InjectionListener;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

public class AnnotatedMethodTypeListener<T extends Annotation>
implements TypeListener {
    private final Class<T> annotationClass;
    private final MethodPostProcessor<T> postProcessor;

    public AnnotatedMethodTypeListener(Class<T> annotationClass, MethodPostProcessor<T> postProcessor) {
        this.annotationClass = annotationClass;
        this.postProcessor = postProcessor;
    }

    public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
        Class actualType = type.getRawType();
        if (!Utils.isPackageValid(actualType)) {
            return;
        }
        for (Class investigatingType = actualType; investigatingType != null && !investigatingType.equals(Object.class); investigatingType = investigatingType.getSuperclass()) {
            for (final Method method : investigatingType.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(this.annotationClass)) continue;
                encounter.register(new InjectionListener<I>(){

                    public void afterInjection(I injected) {
                        try {
                            method.setAccessible(true);
                            AnnotatedMethodTypeListener.this.postProcessor.process(method.getAnnotation(AnnotatedMethodTypeListener.this.annotationClass), method, injected);
                        }
                        catch (Exception ex) {
                            throw new IllegalStateException(String.format("Failed to process annotation %s on method %s of class %s", AnnotatedMethodTypeListener.this.annotationClass.getSimpleName(), method.getName(), injected.getClass().getSimpleName()), ex);
                        }
                    }
                });
            }
        }
    }
}

