/*
 * Decompiled with CFR 0.152.
 */
package com.github.zhengframework.guice;

import com.github.zhengframework.guice.Destroyable;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DestroyableManager {
    private static final Logger log = LoggerFactory.getLogger(DestroyableManager.class);
    private final List<Destroyable> destroyListeners = new ArrayList<Destroyable>();

    public DestroyableManager() {
        Runtime.getRuntime().addShutdownHook(new Thread(this::destroy));
    }

    public synchronized void register(Destroyable destroyable) {
        this.destroyListeners.add(destroyable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        DestroyableManager destroyableManager = this;
        synchronized (destroyableManager) {
            for (Destroyable destroyable : this.destroyListeners) {
                try {
                    destroyable.preDestroy();
                }
                catch (Exception ex) {
                    log.error("Failed to properly destroy bean", (Throwable)ex);
                }
            }
            this.destroyListeners.clear();
        }
    }
}

